package eu.qimpress.ide.editors.gmf.repository.diagram.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.CompositeComponentEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.InterfaceEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.MessageTypeEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.PrimitiveComponentEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.RepositoryEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.part.Messages;
import eu.qimpress.ide.editors.gmf.repository.diagram.part.SammDiagramEditorPlugin;

/**
 * @generated
 */
public class SammModelingAssistantProvider extends ModelingAssistantProvider {

	/**
	 * @generated
	 */
	public List getTypesForPopupBar(IAdaptable host) {
		IGraphicalEditPart editPart = (IGraphicalEditPart) host
				.getAdapter(IGraphicalEditPart.class);
		if (editPart instanceof MessageTypeEditPart) {
			ArrayList types = new ArrayList(1);
			types.add(SammElementTypes.Parameter_3002);
			return types;
		}
		if (editPart instanceof CompositeComponentEditPart) {
			ArrayList types = new ArrayList(4);
			types.add(SammElementTypes.SubcomponentInstance_3005);
			types.add(SammElementTypes.SeffBehaviourStub_3006);
			types.add(SammElementTypes.GastBehaviourStub_3008);
			types.add(SammElementTypes.TBPBehaviourStub_3007);
			return types;
		}
		if (editPart instanceof PrimitiveComponentEditPart) {
			ArrayList types = new ArrayList(4);
			types.add(SammElementTypes.SeffBehaviourStub_3006);
			types.add(SammElementTypes.GastBehaviourStub_3008);
			// @custom-gen disable assistant tools for abstract elements (/templates/aspects/xpt/providers/ModelingAssistantProvider.xpt)
			// types.add(eu.qimpress.ide.editors.gmf.repository.diagram.providers.SammElementTypes.OperationBehaviour_3003); 
			types.add(SammElementTypes.TBPBehaviourStub_3007);
			return types;
		}
		if (editPart instanceof InterfaceEditPart) {
			ArrayList types = new ArrayList(1);
			types.add(SammElementTypes.Operation_3001);
			return types;
		}
		if (editPart instanceof RepositoryEditPart) {
			ArrayList types = new ArrayList(4);
			types.add(SammElementTypes.MessageType_2001);
			types.add(SammElementTypes.CompositeComponent_2002);
			types.add(SammElementTypes.PrimitiveComponent_2003);
			types.add(SammElementTypes.Interface_2004);
			return types;
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getRelTypesOnSource(IAdaptable source) {
		IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source
				.getAdapter(IGraphicalEditPart.class);
		if (sourceEditPart instanceof CompositeComponentEditPart) {
			return ((CompositeComponentEditPart) sourceEditPart).getMARelTypesOnSource();
		}
		if (sourceEditPart instanceof PrimitiveComponentEditPart) {
			return ((PrimitiveComponentEditPart) sourceEditPart).getMARelTypesOnSource();
		}
		if (sourceEditPart instanceof InterfaceEditPart) {
			return ((InterfaceEditPart) sourceEditPart).getMARelTypesOnSource();
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getRelTypesOnTarget(IAdaptable target) {
		IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target
				.getAdapter(IGraphicalEditPart.class);
		if (targetEditPart instanceof MessageTypeEditPart) {
			return ((MessageTypeEditPart) targetEditPart).getMARelTypesOnTarget();
		}
		if (targetEditPart instanceof InterfaceEditPart) {
			return ((InterfaceEditPart) targetEditPart).getMARelTypesOnTarget();
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getRelTypesOnSourceAndTarget(IAdaptable source, IAdaptable target) {
		IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source
				.getAdapter(IGraphicalEditPart.class);
		IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target
				.getAdapter(IGraphicalEditPart.class);
		if (sourceEditPart instanceof CompositeComponentEditPart) {
			return ((CompositeComponentEditPart) sourceEditPart)
					.getMARelTypesOnSourceAndTarget(targetEditPart);
		}
		if (sourceEditPart instanceof PrimitiveComponentEditPart) {
			return ((PrimitiveComponentEditPart) sourceEditPart)
					.getMARelTypesOnSourceAndTarget(targetEditPart);
		}
		if (sourceEditPart instanceof InterfaceEditPart) {
			return ((InterfaceEditPart) sourceEditPart)
					.getMARelTypesOnSourceAndTarget(targetEditPart);
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getTypesForSource(IAdaptable target, IElementType relationshipType) {
		IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target
				.getAdapter(IGraphicalEditPart.class);
		if (targetEditPart instanceof MessageTypeEditPart) {
			return ((MessageTypeEditPart) targetEditPart).getMATypesForSource(relationshipType);
		}
		if (targetEditPart instanceof InterfaceEditPart) {
			return ((InterfaceEditPart) targetEditPart).getMATypesForSource(relationshipType);
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public List getTypesForTarget(IAdaptable source, IElementType relationshipType) {
		IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source
				.getAdapter(IGraphicalEditPart.class);
		if (sourceEditPart instanceof CompositeComponentEditPart) {
			return ((CompositeComponentEditPart) sourceEditPart)
					.getMATypesForTarget(relationshipType);
		}
		if (sourceEditPart instanceof PrimitiveComponentEditPart) {
			return ((PrimitiveComponentEditPart) sourceEditPart)
					.getMATypesForTarget(relationshipType);
		}
		if (sourceEditPart instanceof InterfaceEditPart) {
			return ((InterfaceEditPart) sourceEditPart).getMATypesForTarget(relationshipType);
		}
		return Collections.EMPTY_LIST;
	}

	/**
	 * @generated
	 */
	public EObject selectExistingElementForSource(IAdaptable target, IElementType relationshipType) {
		return selectExistingElement(target, getTypesForSource(target, relationshipType));
	}

	/**
	 * @generated
	 */
	public EObject selectExistingElementForTarget(IAdaptable source, IElementType relationshipType) {
		return selectExistingElement(source, getTypesForTarget(source, relationshipType));
	}

	/**
	 * @generated
	 */
	protected EObject selectExistingElement(IAdaptable host, Collection types) {
		if (types.isEmpty()) {
			return null;
		}
		IGraphicalEditPart editPart = (IGraphicalEditPart) host
				.getAdapter(IGraphicalEditPart.class);
		if (editPart == null) {
			return null;
		}
		Diagram diagram = (Diagram) editPart.getRoot().getContents().getModel();
		Collection elements = new HashSet();
		for (Iterator it = diagram.getElement().eAllContents(); it.hasNext();) {
			EObject element = (EObject) it.next();
			if (isApplicableElement(element, types)) {
				elements.add(element);
			}
		}
		if (elements.isEmpty()) {
			return null;
		}
		return selectElement((EObject[]) elements.toArray(new EObject[elements.size()]));
	}

	/**
	 * @generated
	 */
	protected boolean isApplicableElement(EObject element, Collection types) {
		IElementType type = ElementTypeRegistry.getInstance().getElementType(element);
		return types.contains(type);
	}

	/**
	 * @generated
	 */
	protected EObject selectElement(EObject[] elements) {
		Shell shell = Display.getCurrent().getActiveShell();
		ILabelProvider labelProvider = new AdapterFactoryLabelProvider(SammDiagramEditorPlugin
				.getInstance().getItemProvidersAdapterFactory());
		ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, labelProvider);
		dialog.setMessage(Messages.SammModelingAssistantProviderMessage);
		dialog.setTitle(Messages.SammModelingAssistantProviderTitle);
		dialog.setMultipleSelection(false);
		dialog.setElements(elements);
		EObject selected = null;
		if (dialog.open() == Window.OK) {
			selected = (EObject) dialog.getFirstResult();
		}
		return selected;
	}
}
