package eu.qimpress.ide.editors.gmf.repository.diagram.navigator;

import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.CompositeComponentEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.CompositeComponentNameEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.EventPort2EditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.EventPort2NameEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.EventPortEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.EventPortNameEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.GastBehaviourStubEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.InterfaceEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.InterfaceInheritanceEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.InterfaceNameEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.InterfacePort2EditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.InterfacePort2NameEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.InterfacePortEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.InterfacePortNameEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.MessageTypeEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.MessageTypeNameEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.OperationBehaviourEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.OperationEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.ParameterEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.PrimitiveComponentEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.PrimitiveComponentNameEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.RepositoryEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.SeffBehaviourStubEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.SubcomponentInstanceEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.TBPBehaviourStubEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.part.SammDiagramEditorPlugin;
import eu.qimpress.ide.editors.gmf.repository.diagram.part.SammVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.repository.diagram.providers.SammElementTypes;
import eu.qimpress.ide.editors.gmf.repository.diagram.providers.SammParserProvider;
import eu.qimpress.samm.staticstructure.Repository;

/**
 * @generated
 */
public class SammNavigatorLabelProvider extends LabelProvider implements ICommonLabelProvider,
		ITreePathLabelProvider {

	/**
	 * @generated
	 */
	static {
		SammDiagramEditorPlugin.getInstance().getImageRegistry().put(
				"Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor()); //$NON-NLS-1$
		SammDiagramEditorPlugin.getInstance().getImageRegistry().put(
				"Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor()); //$NON-NLS-1$
	}

	/**
	 * @generated
	 */
	public void updateLabel(ViewerLabel label, TreePath elementPath) {
		Object element = elementPath.getLastSegment();
		if (element instanceof SammNavigatorItem
				&& !isOwnView(((SammNavigatorItem) element).getView())) {
			return;
		}
		label.setText(getText(element));
		label.setImage(getImage(element));
	}

	/**
	 * @generated
	 */
	public Image getImage(Object element) {
		if (element instanceof SammNavigatorGroup) {
			SammNavigatorGroup group = (SammNavigatorGroup) element;
			return SammDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
		}

		if (element instanceof SammNavigatorItem) {
			SammNavigatorItem navigatorItem = (SammNavigatorItem) element;
			if (!isOwnView(navigatorItem.getView())) {
				return super.getImage(element);
			}
			return getImage(navigatorItem.getView());
		}

		return super.getImage(element);
	}

	/**
	 * @generated
	 */
	public Image getImage(View view) {
		switch (SammVisualIDRegistry.getVisualID(view)) {
		case RepositoryEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Diagram?http://q-impress.eu/samm/staticstructure?Repository", SammElementTypes.Repository_1000); //$NON-NLS-1$
		case MessageTypeEditPart.VISUAL_ID:
			return getImage(
					"Navigator?TopLevelNode?http://q-impress.eu/samm/staticstructure?MessageType", SammElementTypes.MessageType_2001); //$NON-NLS-1$
		case CompositeComponentEditPart.VISUAL_ID:
			return getImage(
					"Navigator?TopLevelNode?http://q-impress.eu/samm/staticstructure?CompositeComponent", SammElementTypes.CompositeComponent_2002); //$NON-NLS-1$
		case PrimitiveComponentEditPart.VISUAL_ID:
			return getImage(
					"Navigator?TopLevelNode?http://q-impress.eu/samm/staticstructure?PrimitiveComponent", SammElementTypes.PrimitiveComponent_2003); //$NON-NLS-1$
		case InterfaceEditPart.VISUAL_ID:
			return getImage(
					"Navigator?TopLevelNode?http://q-impress.eu/samm/staticstructure?Interface", SammElementTypes.Interface_2004); //$NON-NLS-1$
		case ParameterEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?Parameter", SammElementTypes.Parameter_3002); //$NON-NLS-1$
		case SubcomponentInstanceEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?SubcomponentInstance", SammElementTypes.SubcomponentInstance_3005); //$NON-NLS-1$
		case SeffBehaviourStubEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/behaviour?SeffBehaviourStub", SammElementTypes.SeffBehaviourStub_3006); //$NON-NLS-1$
		case GastBehaviourStubEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/behaviour?GastBehaviourStub", SammElementTypes.GastBehaviourStub_3008); //$NON-NLS-1$
		case TBPBehaviourStubEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/behaviour?TBPBehaviourStub", SammElementTypes.TBPBehaviourStub_3007); //$NON-NLS-1$
		case OperationBehaviourEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/behaviour?OperationBehaviour", SammElementTypes.OperationBehaviour_3003); //$NON-NLS-1$
		case OperationEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?Operation", SammElementTypes.Operation_3001); //$NON-NLS-1$
		case InterfacePortEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Link?http://q-impress.eu/samm/staticstructure?InterfacePort", SammElementTypes.InterfacePort_4001); //$NON-NLS-1$
		case InterfacePort2EditPart.VISUAL_ID:
			return getImage(
					"Navigator?Link?http://q-impress.eu/samm/staticstructure?InterfacePort", SammElementTypes.InterfacePort_4004); //$NON-NLS-1$
		case EventPortEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Link?http://q-impress.eu/samm/staticstructure?EventPort", SammElementTypes.EventPort_4002); //$NON-NLS-1$
		case EventPort2EditPart.VISUAL_ID:
			return getImage(
					"Navigator?Link?http://q-impress.eu/samm/staticstructure?EventPort", SammElementTypes.EventPort_4005); //$NON-NLS-1$
		case InterfaceInheritanceEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Link?http://q-impress.eu/samm/staticstructure?Interface?inheritance", SammElementTypes.InterfaceInheritance_4003); //$NON-NLS-1$
		}
		return getImage("Navigator?UnknownElement", null); //$NON-NLS-1$
	}

	/**
	 * @generated
	 */
	private Image getImage(String key, IElementType elementType) {
		ImageRegistry imageRegistry = SammDiagramEditorPlugin.getInstance().getImageRegistry();
		Image image = imageRegistry.get(key);
		if (image == null && elementType != null
				&& SammElementTypes.isKnownElementType(elementType)) {
			image = SammElementTypes.getImage(elementType);
			imageRegistry.put(key, image);
		}

		if (image == null) {
			image = imageRegistry.get("Navigator?ImageNotFound"); //$NON-NLS-1$
			imageRegistry.put(key, image);
		}
		return image;
	}

	/**
	 * @generated
	 */
	public String getText(Object element) {
		if (element instanceof SammNavigatorGroup) {
			SammNavigatorGroup group = (SammNavigatorGroup) element;
			return group.getGroupName();
		}

		if (element instanceof SammNavigatorItem) {
			SammNavigatorItem navigatorItem = (SammNavigatorItem) element;
			if (!isOwnView(navigatorItem.getView())) {
				return null;
			}
			return getText(navigatorItem.getView());
		}

		return super.getText(element);
	}

	/**
	 * @generated
	 */
	public String getText(View view) {
		if (view.getElement() != null && view.getElement().eIsProxy()) {
			return getUnresolvedDomainElementProxyText(view);
		}
		switch (SammVisualIDRegistry.getVisualID(view)) {
		case RepositoryEditPart.VISUAL_ID:
			return getRepository_1000Text(view);
		case MessageTypeEditPart.VISUAL_ID:
			return getMessageType_2001Text(view);
		case CompositeComponentEditPart.VISUAL_ID:
			return getCompositeComponent_2002Text(view);
		case PrimitiveComponentEditPart.VISUAL_ID:
			return getPrimitiveComponent_2003Text(view);
		case InterfaceEditPart.VISUAL_ID:
			return getInterface_2004Text(view);
		case ParameterEditPart.VISUAL_ID:
			return getParameter_3002Text(view);
		case SubcomponentInstanceEditPart.VISUAL_ID:
			return getSubcomponentInstance_3005Text(view);
		case SeffBehaviourStubEditPart.VISUAL_ID:
			return getSeffBehaviourStub_3006Text(view);
		case GastBehaviourStubEditPart.VISUAL_ID:
			return getGastBehaviourStub_3008Text(view);
		case TBPBehaviourStubEditPart.VISUAL_ID:
			return getTBPBehaviourStub_3007Text(view);
		case OperationBehaviourEditPart.VISUAL_ID:
			return getOperationBehaviour_3003Text(view);
		case OperationEditPart.VISUAL_ID:
			return getOperation_3001Text(view);
		case InterfacePortEditPart.VISUAL_ID:
			return getInterfacePort_4001Text(view);
		case InterfacePort2EditPart.VISUAL_ID:
			return getInterfacePort_4004Text(view);
		case EventPortEditPart.VISUAL_ID:
			return getEventPort_4002Text(view);
		case EventPort2EditPart.VISUAL_ID:
			return getEventPort_4005Text(view);
		case InterfaceInheritanceEditPart.VISUAL_ID:
			return getInterfaceInheritance_4003Text(view);
		}
		return getUnknownElementText(view);
	}

	/**
	 * @generated
	 */
	private String getRepository_1000Text(View view) {
		Repository domainModelElement = (Repository) view.getElement();
		if (domainModelElement != null) {
			return domainModelElement.getName();
		} else {
			SammDiagramEditorPlugin.getInstance().logError(
					"No domain element for view with visualID = " + 1000); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getMessageType_2001Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.MessageType_2001, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(MessageTypeNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5001); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getCompositeComponent_2002Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.CompositeComponent_2002,
				view.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
						.getType(CompositeComponentNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5002); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getPrimitiveComponent_2003Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.PrimitiveComponent_2003,
				view.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
						.getType(PrimitiveComponentNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5003); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getInterface_2004Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.Interface_2004, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(InterfaceNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5004); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getParameter_3002Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.Parameter_3002, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(ParameterEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 3002); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getSubcomponentInstance_3005Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.SubcomponentInstance_3005,
				view.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
						.getType(SubcomponentInstanceEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 3005); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getOperationBehaviour_3003Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.OperationBehaviour_3003,
				view.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
						.getType(OperationBehaviourEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 3003); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getSeffBehaviourStub_3006Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.SeffBehaviourStub_3006, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(SeffBehaviourStubEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 3006); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getGastBehaviourStub_3008Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.GastBehaviourStub_3008, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(GastBehaviourStubEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 3008); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getTBPBehaviourStub_3007Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.TBPBehaviourStub_3007, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(TBPBehaviourStubEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 3007); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getOperation_3001Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.Operation_3001, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(OperationEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 3001); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getInterfacePort_4001Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.InterfacePort_4001, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(InterfacePortNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 6001); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getInterfacePort_4004Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.InterfacePort_4004, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(InterfacePort2NameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 6003); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getEventPort_4002Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.EventPort_4002, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(EventPortNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 6002); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getEventPort_4005Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.EventPort_4005, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(EventPort2NameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 6004); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getInterfaceInheritance_4003Text(View view) {
		return ""; //$NON-NLS-1$
	}

	/**
	 * @generated
	 */
	private String getUnknownElementText(View view) {
		return "<UnknownElement Visual_ID = " + view.getType() + ">"; //$NON-NLS-1$  //$NON-NLS-2$
	}

	/**
	 * @generated
	 */
	private String getUnresolvedDomainElementProxyText(View view) {
		return "<Unresolved domain element Visual_ID = " + view.getType() + ">"; //$NON-NLS-1$  //$NON-NLS-2$
	}

	/**
	 * @generated
	 */
	public void init(ICommonContentExtensionSite aConfig) {
	}

	/**
	 * @generated
	 */
	public void restoreState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public void saveState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public String getDescription(Object anElement) {
		return null;
	}

	/**
	 * @generated
	 */
	private boolean isOwnView(View view) {
		return RepositoryEditPart.MODEL_ID.equals(SammVisualIDRegistry.getModelID(view));
	}

}
