package eu.qimpress.ide.editors.gmf.repository.diagram.edit.policies;

import java.util.Iterator;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands.EventPort2CreateCommand;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands.EventPort2ReorientCommand;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands.EventPortCreateCommand;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands.EventPortReorientCommand;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands.InterfacePort2CreateCommand;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands.InterfacePort2ReorientCommand;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands.InterfacePortCreateCommand;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands.InterfacePortReorientCommand;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.CompositeComponentComponentTypeBehaviourListEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.CompositeComponentOperationBehaviourListEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.CompositeComponentSubcomponentListEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.EventPort2EditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.EventPortEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.GastBehaviourStubEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.InterfacePort2EditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.InterfacePortEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.OperationBehaviourEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.SeffBehaviourStubEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.SubcomponentInstanceEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.TBPBehaviourStubEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.part.SammVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.repository.diagram.providers.SammElementTypes;

/**
 * @generated
 */
public class CompositeComponentItemSemanticEditPolicy extends SammBaseItemSemanticEditPolicy {

	/**
	 * @generated
	 */
	public CompositeComponentItemSemanticEditPolicy() {
		super(SammElementTypes.CompositeComponent_2002);
	}

	/**
	 * @generated
	 */
	protected Command getDestroyElementCommand(DestroyElementRequest req) {
		View view = (View) getHost().getModel();
		CompositeTransactionalCommand cmd = new CompositeTransactionalCommand(getEditingDomain(),
				null);
		cmd.setTransactionNestingEnabled(false);
		for (Iterator it = view.getSourceEdges().iterator(); it.hasNext();) {
			Edge outgoingLink = (Edge) it.next();
			if (SammVisualIDRegistry.getVisualID(outgoingLink) == InterfacePortEditPart.VISUAL_ID) {
				DestroyElementRequest r = new DestroyElementRequest(outgoingLink.getElement(),
						false);
				cmd.add(new DestroyElementCommand(r));
				cmd.add(new DeleteCommand(getEditingDomain(), outgoingLink));
				continue;
			}
			if (SammVisualIDRegistry.getVisualID(outgoingLink) == InterfacePort2EditPart.VISUAL_ID) {
				DestroyElementRequest r = new DestroyElementRequest(outgoingLink.getElement(),
						false);
				cmd.add(new DestroyElementCommand(r));
				cmd.add(new DeleteCommand(getEditingDomain(), outgoingLink));
				continue;
			}
			if (SammVisualIDRegistry.getVisualID(outgoingLink) == EventPortEditPart.VISUAL_ID) {
				DestroyElementRequest r = new DestroyElementRequest(outgoingLink.getElement(),
						false);
				cmd.add(new DestroyElementCommand(r));
				cmd.add(new DeleteCommand(getEditingDomain(), outgoingLink));
				continue;
			}
			if (SammVisualIDRegistry.getVisualID(outgoingLink) == EventPort2EditPart.VISUAL_ID) {
				DestroyElementRequest r = new DestroyElementRequest(outgoingLink.getElement(),
						false);
				cmd.add(new DestroyElementCommand(r));
				cmd.add(new DeleteCommand(getEditingDomain(), outgoingLink));
				continue;
			}
		}
		EAnnotation annotation = view.getEAnnotation("Shortcut"); //$NON-NLS-1$
		if (annotation == null) {
			// there are indirectly referenced children, need extra commands: false
			addDestroyChildNodesCommand(cmd);
			addDestroyShortcutsCommand(cmd, view);
			// delete host element
			cmd.add(new DestroyElementCommand(req));
		} else {
			cmd.add(new DeleteCommand(getEditingDomain(), view));
		}
		return getGEFWrapper(cmd.reduce());
	}

	/**
	 * @generated
	 */
	private void addDestroyChildNodesCommand(ICompositeCommand cmd) {
		View view = (View) getHost().getModel();
		for (Iterator nit = view.getChildren().iterator(); nit.hasNext();) {
			Node node = (Node) nit.next();
			switch (SammVisualIDRegistry.getVisualID(node)) {
			case CompositeComponentSubcomponentListEditPart.VISUAL_ID:
				for (Iterator cit = node.getChildren().iterator(); cit.hasNext();) {
					Node cnode = (Node) cit.next();
					switch (SammVisualIDRegistry.getVisualID(cnode)) {
					case SubcomponentInstanceEditPart.VISUAL_ID:
						cmd.add(new DestroyElementCommand(new DestroyElementRequest(
								getEditingDomain(), cnode.getElement(), false))); // directlyOwned: true
						// don't need explicit deletion of cnode as parent's view deletion would clean child views as well 
						// cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), cnode));
						break;
					}
				}
				break;
			case CompositeComponentOperationBehaviourListEditPart.VISUAL_ID:
				for (Iterator cit = node.getChildren().iterator(); cit.hasNext();) {
					Node cnode = (Node) cit.next();
					switch (SammVisualIDRegistry.getVisualID(cnode)) {
					case SeffBehaviourStubEditPart.VISUAL_ID:
						cmd.add(new DestroyElementCommand(new DestroyElementRequest(
								getEditingDomain(), cnode.getElement(), false))); // directlyOwned: true
						// don't need explicit deletion of cnode as parent's view deletion would clean child views as well 
						// cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), cnode));
						break;
					case GastBehaviourStubEditPart.VISUAL_ID:
						cmd.add(new DestroyElementCommand(new DestroyElementRequest(
								getEditingDomain(), cnode.getElement(), false))); // directlyOwned: true
						// don't need explicit deletion of cnode as parent's view deletion would clean child views as well 
						// cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), cnode));
						break;
					}
				}
				break;
			case CompositeComponentComponentTypeBehaviourListEditPart.VISUAL_ID:
				for (Iterator cit = node.getChildren().iterator(); cit.hasNext();) {
					Node cnode = (Node) cit.next();
					switch (SammVisualIDRegistry.getVisualID(cnode)) {
					case TBPBehaviourStubEditPart.VISUAL_ID:
						cmd.add(new DestroyElementCommand(new DestroyElementRequest(
								getEditingDomain(), cnode.getElement(), false))); // directlyOwned: true
						// don't need explicit deletion of cnode as parent's view deletion would clean child views as well 
						// cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), cnode));
						break;
					}
				}
				break;
			}
		}
	}

	/**
	 * @generated
	 */
	protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
		Command command = req.getTarget() == null ? getStartCreateRelationshipCommand(req)
				: getCompleteCreateRelationshipCommand(req);
		return command != null ? command : super.getCreateRelationshipCommand(req);
	}

	/**
	 * @generated
	 */
	protected Command getStartCreateRelationshipCommand(CreateRelationshipRequest req) {
		if (SammElementTypes.InterfacePort_4001 == req.getElementType()) {
			return getGEFWrapper(new InterfacePortCreateCommand(req, req.getSource(), req
					.getTarget()));
		}
		if (SammElementTypes.InterfacePort_4004 == req.getElementType()) {
			return getGEFWrapper(new InterfacePort2CreateCommand(req, req.getSource(), req
					.getTarget()));
		}
		if (SammElementTypes.EventPort_4002 == req.getElementType()) {
			return getGEFWrapper(new EventPortCreateCommand(req, req.getSource(), req.getTarget()));
		}
		if (SammElementTypes.EventPort_4005 == req.getElementType()) {
			return getGEFWrapper(new EventPort2CreateCommand(req, req.getSource(), req.getTarget()));
		}
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getCompleteCreateRelationshipCommand(CreateRelationshipRequest req) {
		if (SammElementTypes.InterfacePort_4001 == req.getElementType()) {
			return null;
		}
		if (SammElementTypes.InterfacePort_4004 == req.getElementType()) {
			return null;
		}
		if (SammElementTypes.EventPort_4002 == req.getElementType()) {
			return null;
		}
		if (SammElementTypes.EventPort_4005 == req.getElementType()) {
			return null;
		}
		return null;
	}

	/**
	 * Returns command to reorient EClass based link. New link target or source
	 * should be the domain model element associated with this node.
	 * 
	 * @generated
	 */
	protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
		switch (getVisualID(req)) {
		case InterfacePortEditPart.VISUAL_ID:
			return getGEFWrapper(new InterfacePortReorientCommand(req));
		case InterfacePort2EditPart.VISUAL_ID:
			return getGEFWrapper(new InterfacePort2ReorientCommand(req));
		case EventPortEditPart.VISUAL_ID:
			return getGEFWrapper(new EventPortReorientCommand(req));
		case EventPort2EditPart.VISUAL_ID:
			return getGEFWrapper(new EventPort2ReorientCommand(req));
		}
		return super.getReorientRelationshipCommand(req);
	}

}
