package eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;

import eu.qimpress.ide.editors.gmf.repository.diagram.part.SammVisualIDRegistry;

/**
 * @generated
 */
public class SammEditPartFactory implements EditPartFactory {

	/**
	 * @generated
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		if (model instanceof View) {
			View view = (View) model;
			switch (SammVisualIDRegistry.getVisualID(view)) {

			case RepositoryEditPart.VISUAL_ID:
				return new RepositoryEditPart(view);

			case MessageTypeEditPart.VISUAL_ID:
				return new MessageTypeEditPart(view);

			case MessageTypeNameEditPart.VISUAL_ID:
				return new MessageTypeNameEditPart(view);

			case CompositeComponentEditPart.VISUAL_ID:
				return new CompositeComponentEditPart(view);

			case CompositeComponentNameEditPart.VISUAL_ID:
				return new CompositeComponentNameEditPart(view);

			case PrimitiveComponentEditPart.VISUAL_ID:
				return new PrimitiveComponentEditPart(view);

			case PrimitiveComponentNameEditPart.VISUAL_ID:
				return new PrimitiveComponentNameEditPart(view);

			case InterfaceEditPart.VISUAL_ID:
				return new InterfaceEditPart(view);

			case InterfaceNameEditPart.VISUAL_ID:
				return new InterfaceNameEditPart(view);

			case ParameterEditPart.VISUAL_ID:
				return new ParameterEditPart(view);

			case SubcomponentInstanceEditPart.VISUAL_ID:
				return new SubcomponentInstanceEditPart(view);

			case SeffBehaviourStubEditPart.VISUAL_ID:
				return new SeffBehaviourStubEditPart(view);

			case GastBehaviourStubEditPart.VISUAL_ID:
				return new GastBehaviourStubEditPart(view);

			case TBPBehaviourStubEditPart.VISUAL_ID:
				return new TBPBehaviourStubEditPart(view);

			case OperationBehaviourEditPart.VISUAL_ID:
				return new OperationBehaviourEditPart(view);

			case OperationEditPart.VISUAL_ID:
				return new OperationEditPart(view);

			case MessageTypeParameterListEditPart.VISUAL_ID:
				return new MessageTypeParameterListEditPart(view);

			case CompositeComponentSubcomponentListEditPart.VISUAL_ID:
				return new CompositeComponentSubcomponentListEditPart(view);

			case CompositeComponentOperationBehaviourListEditPart.VISUAL_ID:
				return new CompositeComponentOperationBehaviourListEditPart(view);

			case CompositeComponentComponentTypeBehaviourListEditPart.VISUAL_ID:
				return new CompositeComponentComponentTypeBehaviourListEditPart(view);

			case PrimitiveComponentOperationBehaviourListEditPart.VISUAL_ID:
				return new PrimitiveComponentOperationBehaviourListEditPart(view);

			case PrimitiveComponentComponentTypeBehaviourListEditPart.VISUAL_ID:
				return new PrimitiveComponentComponentTypeBehaviourListEditPart(view);

			case InterfaceOperationListEditPart.VISUAL_ID:
				return new InterfaceOperationListEditPart(view);

			case InterfacePortEditPart.VISUAL_ID:
				return new InterfacePortEditPart(view);

			case InterfacePortNameEditPart.VISUAL_ID:
				return new InterfacePortNameEditPart(view);

			case InterfacePort2EditPart.VISUAL_ID:
				return new InterfacePort2EditPart(view);

			case InterfacePort2NameEditPart.VISUAL_ID:
				return new InterfacePort2NameEditPart(view);

			case EventPortEditPart.VISUAL_ID:
				return new EventPortEditPart(view);

			case EventPortNameEditPart.VISUAL_ID:
				return new EventPortNameEditPart(view);

			case EventPort2EditPart.VISUAL_ID:
				return new EventPort2EditPart(view);

			case EventPort2NameEditPart.VISUAL_ID:
				return new EventPort2NameEditPart(view);

			case InterfaceInheritanceEditPart.VISUAL_ID:
				return new InterfaceInheritanceEditPart(view);

			}
		}
		return createUnrecognizedEditPart(context, model);
	}

	/**
	 * @generated
	 */
	private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
		// Handle creation of unrecognized child node EditParts here
		return null;
	}

	/**
	 * @generated
	 */
	public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
		if (source.getFigure() instanceof WrappingLabel)
			return new TextCellEditorLocator((WrappingLabel) source.getFigure());
		else {
			return new LabelCellEditorLocator((Label) source.getFigure());
		}
	}

	/**
	 * @generated
	 */
	static private class TextCellEditorLocator implements CellEditorLocator {

		/**
		 * @generated
		 */
		private WrappingLabel wrapLabel;

		/**
		 * @generated
		 */
		public TextCellEditorLocator(WrappingLabel wrapLabel) {
			this.wrapLabel = wrapLabel;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getWrapLabel() {
			return wrapLabel;
		}

		/**
		 * @generated
		 */
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			Rectangle rect = getWrapLabel().getTextBounds().getCopy();
			getWrapLabel().translateToAbsolute(rect);
			if (getWrapLabel().isTextWrapOn() && getWrapLabel().getText().length() > 0) {
				rect.setSize(new Dimension(text.computeSize(rect.width, SWT.DEFAULT)));
			} else {
				int avr = FigureUtilities.getFontMetrics(text.getFont()).getAverageCharWidth();
				rect.setSize(new Dimension(text.computeSize(SWT.DEFAULT, SWT.DEFAULT)).expand(
						avr * 2, 0));
			}
			if (!rect.equals(new Rectangle(text.getBounds()))) {
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
			}
		}
	}

	/**
	 * @generated
	 */
	private static class LabelCellEditorLocator implements CellEditorLocator {

		/**
		 * @generated
		 */
		private Label label;

		/**
		 * @generated
		 */
		public LabelCellEditorLocator(Label label) {
			this.label = label;
		}

		/**
		 * @generated
		 */
		public Label getLabel() {
			return label;
		}

		/**
		 * @generated
		 */
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			Rectangle rect = getLabel().getTextBounds().getCopy();
			getLabel().translateToAbsolute(rect);
			int avr = FigureUtilities.getFontMetrics(text.getFont()).getAverageCharWidth();
			rect.setSize(new Dimension(text.computeSize(SWT.DEFAULT, SWT.DEFAULT)).expand(avr * 2,
					0));
			if (!rect.equals(new Rectangle(text.getBounds()))) {
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
			}
		}
	}
}
