package eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

import eu.qimpress.ide.editors.gmf.repository.diagram.edit.policies.PrimitiveComponentItemSemanticEditPolicy;
import eu.qimpress.ide.editors.gmf.repository.diagram.part.SammVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.repository.diagram.providers.SammElementTypes;

/**
 * @generated
 */
public class PrimitiveComponentEditPart extends ShapeNodeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 2003;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public PrimitiveComponentEditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		installEditPolicy(EditPolicyRoles.CREATION_ROLE, new CreationEditPolicy());
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new PrimitiveComponentItemSemanticEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
		// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies
		// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		LayoutEditPolicy lep = new LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				EditPolicy result = child.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		ComponentFigure figure = new ComponentFigure();
		return primaryShape = figure;
	}

	/**
	 * @generated
	 */
	public ComponentFigure getPrimaryShape() {
		return (ComponentFigure) primaryShape;
	}

	/**
	 * @generated
	 */
	protected boolean addFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof PrimitiveComponentNameEditPart) {
			((PrimitiveComponentNameEditPart) childEditPart).setLabel(getPrimaryShape()
					.getFigureComponentNameFigure());
			return true;
		}
		if (childEditPart instanceof PrimitiveComponentOperationBehaviourListEditPart) {
			IFigure pane = getPrimaryShape().getFigureComponentCompartmentFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane
					.add(((PrimitiveComponentOperationBehaviourListEditPart) childEditPart)
							.getFigure());
			return true;
		}
		if (childEditPart instanceof PrimitiveComponentComponentTypeBehaviourListEditPart) {
			IFigure pane = getPrimaryShape().getFigureComponentCompartmentFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.add(((PrimitiveComponentComponentTypeBehaviourListEditPart) childEditPart)
					.getFigure());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected boolean removeFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof PrimitiveComponentNameEditPart) {
			return true;
		}
		if (childEditPart instanceof PrimitiveComponentOperationBehaviourListEditPart) {
			IFigure pane = getPrimaryShape().getFigureComponentCompartmentFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.remove(((PrimitiveComponentOperationBehaviourListEditPart) childEditPart)
					.getFigure());
			return true;
		}
		if (childEditPart instanceof PrimitiveComponentComponentTypeBehaviourListEditPart) {
			IFigure pane = getPrimaryShape().getFigureComponentCompartmentFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.remove(((PrimitiveComponentComponentTypeBehaviourListEditPart) childEditPart)
					.getFigure());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected void addChildVisual(EditPart childEditPart, int index) {
		if (addFixedChild(childEditPart)) {
			return;
		}
		super.addChildVisual(childEditPart, -1);
	}

	/**
	 * @generated
	 */
	protected void removeChildVisual(EditPart childEditPart) {
		if (removeFixedChild(childEditPart)) {
			return;
		}
		super.removeChildVisual(childEditPart);
	}

	/**
	 * @generated
	 */
	protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
		if (editPart instanceof PrimitiveComponentOperationBehaviourListEditPart) {
			return getPrimaryShape().getFigureComponentCompartmentFigure();
		}
		if (editPart instanceof PrimitiveComponentComponentTypeBehaviourListEditPart) {
			return getPrimaryShape().getFigureComponentCompartmentFigure();
		}
		return getContentPane();
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
		return result;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createNodeFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(5);
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	protected void setForegroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setForegroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setBackgroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setBackgroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineWidth(int width) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineWidth(width);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineType(int style) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineStyle(style);
		}
	}

	/**
	 * @generated
	 */
	public EditPart getPrimaryChildEditPart() {
		return getChildBySemanticHint(SammVisualIDRegistry
				.getType(PrimitiveComponentNameEditPart.VISUAL_ID));
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMARelTypesOnSource() {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		types.add(SammElementTypes.InterfacePort_4001);
		types.add(SammElementTypes.InterfacePort_4004);
		types.add(SammElementTypes.EventPort_4002);
		types.add(SammElementTypes.EventPort_4005);
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMARelTypesOnSourceAndTarget(
			IGraphicalEditPart targetEditPart) {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		if (targetEditPart instanceof InterfaceEditPart) {
			types.add(SammElementTypes.InterfacePort_4001);
		}
		if (targetEditPart instanceof InterfaceEditPart) {
			types.add(SammElementTypes.InterfacePort_4004);
		}
		if (targetEditPart instanceof MessageTypeEditPart) {
			types.add(SammElementTypes.EventPort_4002);
		}
		if (targetEditPart instanceof MessageTypeEditPart) {
			types.add(SammElementTypes.EventPort_4005);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMATypesForTarget(
			IElementType relationshipType) {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		if (relationshipType == SammElementTypes.InterfacePort_4001) {
			types.add(SammElementTypes.Interface_2004);
		}
		if (relationshipType == SammElementTypes.InterfacePort_4004) {
			types.add(SammElementTypes.Interface_2004);
		}
		if (relationshipType == SammElementTypes.EventPort_4002) {
			types.add(SammElementTypes.MessageType_2001);
		}
		if (relationshipType == SammElementTypes.EventPort_4005) {
			types.add(SammElementTypes.MessageType_2001);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public EditPart getTargetEditPart(Request request) {
		if (request instanceof CreateViewAndElementRequest) {
			CreateElementRequestAdapter adapter = ((CreateViewAndElementRequest) request)
					.getViewAndElementDescriptor().getCreateElementRequestAdapter();
			IElementType type = (IElementType) adapter.getAdapter(IElementType.class);
			if (type == SammElementTypes.SeffBehaviourStub_3006) {
				return getChildBySemanticHint(SammVisualIDRegistry
						.getType(PrimitiveComponentOperationBehaviourListEditPart.VISUAL_ID));
			}
			if (type == SammElementTypes.GastBehaviourStub_3008) {
				return getChildBySemanticHint(SammVisualIDRegistry
						.getType(PrimitiveComponentOperationBehaviourListEditPart.VISUAL_ID));
			}
			if (type == SammElementTypes.OperationBehaviour_3003) {
				return getChildBySemanticHint(SammVisualIDRegistry
						.getType(PrimitiveComponentOperationBehaviourListEditPart.VISUAL_ID));
			}
			if (type == SammElementTypes.TBPBehaviourStub_3007) {
				return getChildBySemanticHint(SammVisualIDRegistry
						.getType(PrimitiveComponentComponentTypeBehaviourListEditPart.VISUAL_ID));
			}
		}
		return super.getTargetEditPart(request);
	}

	/**
	 * @generated
	 */
	public class ComponentFigure extends RectangleFigure {

		/**
		 * @generated
		 */
		private WrappingLabel fFigureComponentNameFigure;
		/**
		 * @generated
		 */
		private RectangleFigure fFigureComponentCompartmentFigure;

		/**
		 * @generated
		 */
		public ComponentFigure() {

			GridLayout layoutThis = new GridLayout();
			layoutThis.numColumns = 1;
			layoutThis.makeColumnsEqualWidth = true;
			layoutThis.horizontalSpacing = 0;
			layoutThis.verticalSpacing = 0;
			layoutThis.marginWidth = 0;
			layoutThis.marginHeight = 0;
			this.setLayoutManager(layoutThis);

			this.setLineWidth(1);
			createContents();
		}

		/**
		 * @generated
		 */
		private void createContents() {

			fFigureComponentNameFigure = new WrappingLabel();
			fFigureComponentNameFigure.setText("<...>");
			fFigureComponentNameFigure.setBorder(new MarginBorder(getMapMode().DPtoLP(2),
					getMapMode().DPtoLP(0), getMapMode().DPtoLP(2), getMapMode().DPtoLP(0)));

			GridData constraintFFigureComponentNameFigure = new GridData();
			constraintFFigureComponentNameFigure.verticalAlignment = GridData.CENTER;
			constraintFFigureComponentNameFigure.horizontalAlignment = GridData.CENTER;
			constraintFFigureComponentNameFigure.horizontalIndent = 0;
			constraintFFigureComponentNameFigure.horizontalSpan = 1;
			constraintFFigureComponentNameFigure.verticalSpan = 1;
			constraintFFigureComponentNameFigure.grabExcessHorizontalSpace = false;
			constraintFFigureComponentNameFigure.grabExcessVerticalSpace = false;
			this.add(fFigureComponentNameFigure, constraintFFigureComponentNameFigure);

			fFigureComponentCompartmentFigure = new RectangleFigure();
			fFigureComponentCompartmentFigure.setLineWidth(1);

			GridData constraintFFigureComponentCompartmentFigure = new GridData();
			constraintFFigureComponentCompartmentFigure.verticalAlignment = GridData.FILL;
			constraintFFigureComponentCompartmentFigure.horizontalAlignment = GridData.FILL;
			constraintFFigureComponentCompartmentFigure.horizontalIndent = 0;
			constraintFFigureComponentCompartmentFigure.horizontalSpan = 1;
			constraintFFigureComponentCompartmentFigure.verticalSpan = 1;
			constraintFFigureComponentCompartmentFigure.grabExcessHorizontalSpace = true;
			constraintFFigureComponentCompartmentFigure.grabExcessVerticalSpace = true;
			this
					.add(fFigureComponentCompartmentFigure,
							constraintFFigureComponentCompartmentFigure);

		}

		/**
		 * @generated
		 */
		private boolean myUseLocalCoordinates = false;

		/**
		 * @generated
		 */
		protected boolean useLocalCoordinates() {
			return myUseLocalCoordinates;
		}

		/**
		 * @generated
		 */
		protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
			myUseLocalCoordinates = useLocalCoordinates;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureComponentNameFigure() {
			return fFigureComponentNameFigure;
		}

		/**
		 * @generated
		 */
		public RectangleFigure getFigureComponentCompartmentFigure() {
			return fFigureComponentCompartmentFigure;
		}

	}

}
