package eu.qimpress.ide.editors.gmf.repository.diagram.custom.edit.parts;

import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.CompositeComponentEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.CompositeComponentNameEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.GastBehaviourStubEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.OperationBehaviourEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.OperationEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.ParameterEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.SammEditPartFactory;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.SeffBehaviourStubEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.TBPBehaviourStubEditPart;
import eu.qimpress.ide.editors.gmf.repository.diagram.part.SammVisualIDRegistry;

/**
 * @author wsa
 *
 */
public class CustomSammEditPartFactory extends SammEditPartFactory {

	@Override
	public EditPart createEditPart(EditPart context, Object model) {
		if (model instanceof View) {
			View view = (View) model;
			switch (SammVisualIDRegistry.getVisualID(view)) {

			case OperationBehaviourEditPart.VISUAL_ID:
				return new CustomOperationBehaviourEditPart(view);
				
			case SeffBehaviourStubEditPart.VISUAL_ID:
				return new CustomOperationBehaviourEditPart(view);
				
			case GastBehaviourStubEditPart.VISUAL_ID:
				return new CustomOperationBehaviourEditPart(view);
				
			case TBPBehaviourStubEditPart.VISUAL_ID:
				return new CustomTBPBehaviourStubEditPart(view);

			case OperationEditPart.VISUAL_ID:
				return new CustomOperationEditPart(view);

			case CompositeComponentNameEditPart.VISUAL_ID:
				return new CustomCompositeComponentNameEditPart(view);
			
			case CompositeComponentEditPart.VISUAL_ID:
				return new CustomCompositeComponentEditPart(view);
				
			case ParameterEditPart.VISUAL_ID:
				return new CustomParameterEditPart(view);
			}
		}

		return super.createEditPart(context, model);
	}
}
