package eu.qimpress.ide.editors.gmf.repository.diagram.custom.edit.parts;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.OperationEditPart;
import eu.qimpress.ide.ui.provider.OperationPrinter;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;

/**
 * @author wsa
 *
 */
public class CustomOperationEditPart extends OperationEditPart {

//	private static final int MAX_OPERATION_DISPLAY_LENGTH = 50;
	
	public CustomOperationEditPart(View view) {
		super(view);
	}

	@Override
	protected String getLabelText() {
		String text = null;
		EObject parserElement = getParserElement();
		if (parserElement != null) {
			text = new OperationPrinter().doSwitch(parserElement);
		}
		if (text == null || text.length() == 0) {
			text = super.getLabelText();
		}
		return text;
	}
	
	@Override
	protected void handleNotificationEvent(Notification event) {
		Object feature = event.getFeature();
		if (StaticstructurePackage.eINSTANCE.getOperation_Input().equals(feature) || 
			StaticstructurePackage.eINSTANCE.getOperation_Output().equals(feature) ||
			StaticstructurePackage.eINSTANCE.getOperation_ThrowsExceptions().equals(feature)) {
			this.handleMajorSemanticChange();
		} else {
			super.handleNotificationEvent(event);
		}
	}
	
}
