package eu.qimpress.ide.editors.gmf.repository.diagram.custom.edit.parts;

import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.requests.RequestConstants;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.common.diagram.custom.util.GMFUtils;
import eu.qimpress.ide.editors.gmf.composite.diagram.custom.contributions.OpenCompositeDiagramAction;
import eu.qimpress.ide.editors.gmf.repository.diagram.edit.parts.CompositeComponentEditPart;
import eu.qimpress.samm.staticstructure.CompositeComponent;

/**
 * Enables open diagram behaviour for the CompositeComponent node creating and/or opening
 * the corresponding composite diagram of the parent ComponentComponent on a node double-click.
 * 
 * @author Wladimir
 *
 */
public class CustomCompositeComponentEditPart extends CompositeComponentEditPart {

	public CustomCompositeComponentEditPart(View view) {
		super(view);
	}

	
	public void performRequest(Request request) {
		
		if (RequestConstants.REQ_OPEN==request.getType()) {
			
			CompositeComponent compositeComponent = (CompositeComponent) resolveSemanticElement();
			GMFUtils.createAndOpenDiagram(compositeComponent, new OpenCompositeDiagramAction(compositeComponent));
		}
		else
			super.performRequest(request);
	}
}
