package eu.qimpress.ide.editors.gmf.repository.diagram.custom.edit.helpers.advices;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.ui.PlatformUI;

import eu.qimpress.ide.editors.dialogs.selection.SammEObjectSelectionDialog;
import eu.qimpress.ide.editors.gmf.common.diagram.custom.commands.CanceledCommand;
import eu.qimpress.ide.editors.gmf.common.diagram.custom.util.GMFUtils;
import eu.qimpress.ide.editors.gmf.common.diagram.custom.util.LogFactory;
import eu.qimpress.ide.editors.gmf.seff.helper.SeffUtils;
import eu.qimpress.samm.behaviour.OperationBehaviour;
import eu.qimpress.samm.behaviour.SeffBehaviourStub;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;
import eu.qimpress.seff.seffFactory;

/**
 * Adds configuration possibility for newly created {@link OperationBehaviour}s
 * allowing to select {@link Operation} for the {@link OperationBehaviour#getOperation() operation} 
 * feature in a pop-up dialog. Selection list is filtered to the <code>Operations</code>
 * in those {@link Interface}s referenced by provided {@link InterfacePort}s of the
 * containing {@link ComponentType}.
 * 
 * @author wsa
 *
 */
public class OperationBehaviourEditHelperAdvice extends AbstractEditHelperAdvice {
	
	Logger log = LogFactory.getLog(OperationBehaviourEditHelperAdvice.class);

	@Override
	protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
		
		ArrayList<Object> filterList = new ArrayList<Object>();
		filterList.add(InterfacePort.class);
		filterList.add(Interface.class);
		filterList.add(Operation.class);
		ArrayList<EReference> additionalReferences = new ArrayList<EReference>();
		additionalReferences.add(StaticstructurePackage.eINSTANCE.getInterfacePort_InterfaceType());
		Set<EReference> excludedContainments = new HashSet<EReference>();
		excludedContainments.add(StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Required());
		SammEObjectSelectionDialog dialog = new SammEObjectSelectionDialog(
				PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
				filterList, 
				additionalReferences,
				excludedContainments,
				request.getElementToConfigure().eContainer());
		dialog.setProvidedService(Operation.class);
		dialog.open();

		if (dialog.getResult() == null)
			return new CanceledCommand();
		if (!(dialog.getResult() instanceof Operation))
			return new CanceledCommand();

		final Operation operation = (Operation) dialog.getResult();
		final OperationBehaviour operationBehaviourStub = (OperationBehaviour) request.getElementToConfigure();
		
		// composite command wrapping the actual model modification command
		ICompositeCommand compCmd = new CompositeCommand("OperationBehaviourEditHelperAdvice command"){
		    protected CommandResult doExecuteWithResult(
		            IProgressMonitor progressMonitor, IAdaptable info)
		        throws ExecutionException {
		    	CommandResult result = super.doExecuteWithResult(progressMonitor, info);
		    	if(result.getStatus().isOK())
		    		GMFUtils.saveActiveEditor();
		    	return result;
		    		
		    }
		};
		
		TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain(operationBehaviourStub);
		RecordingCommand seffCmd = new RecordingCommand(editingDomain) {			
			@Override
			protected void doExecute() {

				// assign operation to the new seff stub
				operationBehaviourStub.setOperation(operation);

				if (operationBehaviourStub instanceof SeffBehaviourStub) {
					// create the corresponding Seff and set the reference to the stub
					SeffRepository repo = SeffUtils.getSeffRepository(operationBehaviourStub);
					ResourceDemandingSEFF seff = seffFactory.eINSTANCE.createResourceDemandingSEFF();
					// TODO: initialize SEFF with Start/StopActions
					seff.setSeffBehaviourStub((SeffBehaviourStub) operationBehaviourStub);
					repo.getResourceDemandingSeff().add(seff);
				}
			}
		};
		compCmd.add(new EMFCommandOperation(editingDomain, seffCmd));
		
		return compCmd;
	}

	

	protected ICommand getAfterDestroyElementCommand(
			DestroyElementRequest request) {
		OperationBehaviour stub = (OperationBehaviour) request.getElementToDestroy();
		if (stub instanceof SeffBehaviourStub) {
			ResourceDemandingSEFF seff = SeffUtils.findReferencingSeff(stub);		
			if (seff != null) {
				// TODO: clean up SEFF diagram resources
				return new DestroyElementCommand(new DestroyElementRequest(seff, false)) {
				
					protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info)
																						throws ExecutionException {
						return super.doExecuteWithResult(monitor, info);
					}
				};
			}
		}
		return null;
	}
}
