package eu.qimpress.ide.editors.gmf.composite.diagram.part;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeConnectionTool;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeCreationTool;

import eu.qimpress.ide.editors.gmf.composite.diagram.providers.SammElementTypes;

/**
 * @generated
 */
public class SammPaletteFactory {

	/**
	 * @generated
	 */
	public void fillPalette(PaletteRoot paletteRoot) {
		paletteRoot.add(createPorts1Group());
		paletteRoot.add(createInnerElements2Group());
	}

	/**
	 * Creates "Ports" palette tool group
	 * @generated
	 */
	private PaletteContainer createPorts1Group() {
		PaletteGroup paletteContainer = new PaletteGroup(Messages.Ports1Group_title);
		paletteContainer.setId("createPorts1Group"); //$NON-NLS-1$
		paletteContainer.setDescription(Messages.Ports1Group_desc);
		paletteContainer.add(createRequiredInterfacePort1CreationTool());
		paletteContainer.add(createProvidedInterfacePort2CreationTool());
		paletteContainer.add(createSourceEventPort3CreationTool());
		paletteContainer.add(createSinkEventPort4CreationTool());
		return paletteContainer;
	}

	/**
	 * Creates "Inner Elements" palette tool group
	 * @generated
	 */
	private PaletteContainer createInnerElements2Group() {
		PaletteDrawer paletteContainer = new PaletteDrawer(Messages.InnerElements2Group_title);
		paletteContainer.setId("createInnerElements2Group"); //$NON-NLS-1$
		paletteContainer.add(createSubcomponentInstance1CreationTool());
		paletteContainer.add(createConnector2CreationTool());
		paletteContainer.add(createSubcomponentEndpoint3CreationTool());
		paletteContainer.add(createComponentEndPoint4CreationTool());
		return paletteContainer;
	}

	/**
	 * @generated
	 */
	private ToolEntry createRequiredInterfacePort1CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(2);
		types.add(SammElementTypes.InterfacePort_3012);
		types.add(SammElementTypes.InterfacePort_3016);
		NodeToolEntry entry = new NodeToolEntry(Messages.RequiredInterfacePort1CreationTool_title,
				null, types);
		entry.setId("createRequiredInterfacePort1CreationTool"); //$NON-NLS-1$
		entry
				.setSmallIcon(SammDiagramEditorPlugin
						.findImageDescriptor("/eu.qimpress.samm.edit/icons/full/obj16/RequiredInterfacePort.gif")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createProvidedInterfacePort2CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(2);
		types.add(SammElementTypes.InterfacePort_3011);
		types.add(SammElementTypes.InterfacePort_3015);
		NodeToolEntry entry = new NodeToolEntry(Messages.ProvidedInterfacePort2CreationTool_title,
				null, types);
		entry.setId("createProvidedInterfacePort2CreationTool"); //$NON-NLS-1$
		entry
				.setSmallIcon(SammDiagramEditorPlugin
						.findImageDescriptor("/eu.qimpress.samm.edit/icons/full/obj16/ProvidedInterfacePort.gif")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createSourceEventPort3CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(2);
		types.add(SammElementTypes.EventPort_3013);
		types.add(SammElementTypes.EventPort_3019);
		NodeToolEntry entry = new NodeToolEntry(Messages.SourceEventPort3CreationTool_title, null,
				types);
		entry.setId("createSourceEventPort3CreationTool"); //$NON-NLS-1$
		entry
				.setSmallIcon(SammDiagramEditorPlugin
						.findImageDescriptor("/eu.qimpress.samm.edit/icons/full/obj16/SourceEventPort.gif")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createSinkEventPort4CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(2);
		types.add(SammElementTypes.EventPort_3014);
		types.add(SammElementTypes.EventPort_3018);
		NodeToolEntry entry = new NodeToolEntry(Messages.SinkEventPort4CreationTool_title, null,
				types);
		entry.setId("createSinkEventPort4CreationTool"); //$NON-NLS-1$
		entry.setSmallIcon(SammDiagramEditorPlugin
				.findImageDescriptor("/eu.qimpress.samm.edit/icons/full/obj16/SinkEventPort.gif")); //$NON-NLS-1$
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createSubcomponentInstance1CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(SammElementTypes.SubcomponentInstance_3001);
		NodeToolEntry entry = new NodeToolEntry(Messages.SubcomponentInstance1CreationTool_title,
				Messages.SubcomponentInstance1CreationTool_desc, types);
		entry.setId("createSubcomponentInstance1CreationTool"); //$NON-NLS-1$
		entry.setSmallIcon(SammElementTypes
				.getImageDescriptor(SammElementTypes.SubcomponentInstance_3001));
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createConnector2CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(SammElementTypes.Connector_3006);
		NodeToolEntry entry = new NodeToolEntry(Messages.Connector2CreationTool_title,
				Messages.Connector2CreationTool_desc, types);
		entry.setId("createConnector2CreationTool"); //$NON-NLS-1$
		entry.setSmallIcon(SammElementTypes.getImageDescriptor(SammElementTypes.Connector_3006));
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createSubcomponentEndpoint3CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(SammElementTypes.SubcomponentEndpoint_4001);
		LinkToolEntry entry = new LinkToolEntry(Messages.SubcomponentEndpoint3CreationTool_title,
				null, types);
		entry.setId("createSubcomponentEndpoint3CreationTool"); //$NON-NLS-1$
		entry.setSmallIcon(SammElementTypes
				.getImageDescriptor(SammElementTypes.SubcomponentEndpoint_4001));
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private ToolEntry createComponentEndPoint4CreationTool() {
		List/*<IElementType>*/types = new ArrayList/*<IElementType>*/(1);
		types.add(SammElementTypes.ComponentEndpoint_4002);
		LinkToolEntry entry = new LinkToolEntry(Messages.ComponentEndPoint4CreationTool_title,
				Messages.ComponentEndPoint4CreationTool_desc, types);
		entry.setId("createComponentEndPoint4CreationTool"); //$NON-NLS-1$
		entry.setSmallIcon(SammElementTypes
				.getImageDescriptor(SammElementTypes.ComponentEndpoint_4002));
		entry.setLargeIcon(entry.getSmallIcon());
		return entry;
	}

	/**
	 * @generated
	 */
	private static class NodeToolEntry extends ToolEntry {

		/**
		 * @generated
		 */
		private final List elementTypes;

		/**
		 * @generated
		 */
		private NodeToolEntry(String title, String description, List elementTypes) {
			super(title, description, null, null);
			this.elementTypes = elementTypes;
		}

		/**
		 * @generated
		 */
		public Tool createTool() {
			Tool tool = new UnspecifiedTypeCreationTool(elementTypes);
			tool.setProperties(getToolProperties());
			return tool;
		}
	}

	/**
	 * @generated
	 */
	private static class LinkToolEntry extends ToolEntry {

		/**
		 * @generated
		 */
		private final List relationshipTypes;

		/**
		 * @generated
		 */
		private LinkToolEntry(String title, String description, List relationshipTypes) {
			super(title, description, null, null);
			this.relationshipTypes = relationshipTypes;
		}

		/**
		 * @generated
		 */
		public Tool createTool() {
			Tool tool = new UnspecifiedTypeConnectionTool(relationshipTypes);
			tool.setProperties(getToolProperties());
			return tool;
		}
	}
}
