package eu.qimpress.ide.editors.gmf.composite.diagram.navigator;

import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.ComponentEndpointEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.CompositeComponentEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.CompositeComponentNameEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.CompositeStructureEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.ConnectorEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPort2EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPort3EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPort4EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPortEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPortName2EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPortName3EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPortName4EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPortNameEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePort2EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePort3EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePort4EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePortEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePortName2EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePortName3EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePortName4EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePortNameEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.ServiceArchitectureModelEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.ServiceArchitectureModelNameEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentEndpointEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentInstance2EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentInstanceEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentInstanceNameEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.WrappingLabelEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammDiagramEditorPlugin;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.composite.diagram.providers.SammElementTypes;
import eu.qimpress.ide.editors.gmf.composite.diagram.providers.SammParserProvider;
import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

/**
 * @generated
 */
public class SammNavigatorLabelProvider extends LabelProvider implements ICommonLabelProvider,
		ITreePathLabelProvider {

	/**
	 * @generated
	 */
	static {
		SammDiagramEditorPlugin.getInstance().getImageRegistry().put(
				"Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor()); //$NON-NLS-1$
		SammDiagramEditorPlugin.getInstance().getImageRegistry().put(
				"Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor()); //$NON-NLS-1$
	}

	/**
	 * @generated
	 */
	public void updateLabel(ViewerLabel label, TreePath elementPath) {
		Object element = elementPath.getLastSegment();
		if (element instanceof SammNavigatorItem
				&& !isOwnView(((SammNavigatorItem) element).getView())) {
			return;
		}
		label.setText(getText(element));
		label.setImage(getImage(element));
	}

	/**
	 * @generated
	 */
	public Image getImage(Object element) {
		if (element instanceof SammNavigatorGroup) {
			SammNavigatorGroup group = (SammNavigatorGroup) element;
			return SammDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
		}

		if (element instanceof SammNavigatorItem) {
			SammNavigatorItem navigatorItem = (SammNavigatorItem) element;
			if (!isOwnView(navigatorItem.getView())) {
				return super.getImage(element);
			}
			return getImage(navigatorItem.getView());
		}

		return super.getImage(element);
	}

	/**
	 * @generated
	 */
	public Image getImage(View view) {
		switch (SammVisualIDRegistry.getVisualID(view)) {
		case CompositeStructureEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Diagram?http://q-impress.eu/samm/staticstructure?CompositeStructure", SammElementTypes.CompositeStructure_1000); //$NON-NLS-1$
		case CompositeComponentEditPart.VISUAL_ID:
			return getImage(
					"Navigator?TopLevelNode?http://q-impress.eu/samm/staticstructure?CompositeComponent", SammElementTypes.CompositeComponent_2005); //$NON-NLS-1$
		case ServiceArchitectureModelEditPart.VISUAL_ID:
			return getImage(
					"Navigator?TopLevelNode?http://q-impress.eu/samm/staticstructure?ServiceArchitectureModel", SammElementTypes.ServiceArchitectureModel_2006); //$NON-NLS-1$
		case SubcomponentInstanceEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?SubcomponentInstance", SammElementTypes.SubcomponentInstance_3001); //$NON-NLS-1$
		case InterfacePortEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?InterfacePort", SammElementTypes.InterfacePort_3011); //$NON-NLS-1$
		case InterfacePort2EditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?InterfacePort", SammElementTypes.InterfacePort_3012); //$NON-NLS-1$
		case EventPortEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?EventPort", SammElementTypes.EventPort_3013); //$NON-NLS-1$
		case EventPort2EditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?EventPort", SammElementTypes.EventPort_3014); //$NON-NLS-1$
		case SubcomponentInstance2EditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?SubcomponentInstance", SammElementTypes.SubcomponentInstance_3020); //$NON-NLS-1$
		case ConnectorEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?Connector", SammElementTypes.Connector_3006); //$NON-NLS-1$
		case InterfacePort3EditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?InterfacePort", SammElementTypes.InterfacePort_3015); //$NON-NLS-1$
		case InterfacePort4EditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?InterfacePort", SammElementTypes.InterfacePort_3016); //$NON-NLS-1$
		case EventPort3EditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?EventPort", SammElementTypes.EventPort_3019); //$NON-NLS-1$
		case EventPort4EditPart.VISUAL_ID:
			return getImage(
					"Navigator?Node?http://q-impress.eu/samm/staticstructure?EventPort", SammElementTypes.EventPort_3018); //$NON-NLS-1$
		case SubcomponentEndpointEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Link?http://q-impress.eu/samm/staticstructure?SubcomponentEndpoint", SammElementTypes.SubcomponentEndpoint_4001); //$NON-NLS-1$
		case ComponentEndpointEditPart.VISUAL_ID:
			return getImage(
					"Navigator?Link?http://q-impress.eu/samm/staticstructure?ComponentEndpoint", SammElementTypes.ComponentEndpoint_4002); //$NON-NLS-1$
		}
		return getImage("Navigator?UnknownElement", null); //$NON-NLS-1$
	}

	/**
	 * @generated
	 */
	private Image getImage(String key, IElementType elementType) {
		ImageRegistry imageRegistry = SammDiagramEditorPlugin.getInstance().getImageRegistry();
		Image image = imageRegistry.get(key);
		if (image == null && elementType != null
				&& SammElementTypes.isKnownElementType(elementType)) {
			image = SammElementTypes.getImage(elementType);
			imageRegistry.put(key, image);
		}

		if (image == null) {
			image = imageRegistry.get("Navigator?ImageNotFound"); //$NON-NLS-1$
			imageRegistry.put(key, image);
		}
		return image;
	}

	/**
	 * @generated
	 */
	public String getText(Object element) {
		if (element instanceof SammNavigatorGroup) {
			SammNavigatorGroup group = (SammNavigatorGroup) element;
			return group.getGroupName();
		}

		if (element instanceof SammNavigatorItem) {
			SammNavigatorItem navigatorItem = (SammNavigatorItem) element;
			if (!isOwnView(navigatorItem.getView())) {
				return null;
			}
			return getText(navigatorItem.getView());
		}

		return super.getText(element);
	}

	/**
	 * @generated
	 */
	public String getText(View view) {
		if (view.getElement() != null && view.getElement().eIsProxy()) {
			return getUnresolvedDomainElementProxyText(view);
		}
		switch (SammVisualIDRegistry.getVisualID(view)) {
		case CompositeStructureEditPart.VISUAL_ID:
			return getCompositeStructure_1000Text(view);
		case CompositeComponentEditPart.VISUAL_ID:
			return getCompositeComponent_2005Text(view);
		case ServiceArchitectureModelEditPart.VISUAL_ID:
			return getServiceArchitectureModel_2006Text(view);
		case SubcomponentInstanceEditPart.VISUAL_ID:
			return getSubcomponentInstance_3001Text(view);
		case InterfacePortEditPart.VISUAL_ID:
			return getInterfacePort_3011Text(view);
		case InterfacePort2EditPart.VISUAL_ID:
			return getInterfacePort_3012Text(view);
		case EventPortEditPart.VISUAL_ID:
			return getEventPort_3013Text(view);
		case EventPort2EditPart.VISUAL_ID:
			return getEventPort_3014Text(view);
		case SubcomponentInstance2EditPart.VISUAL_ID:
			return getSubcomponentInstance_3020Text(view);
		case ConnectorEditPart.VISUAL_ID:
			return getConnector_3006Text(view);
		case InterfacePort3EditPart.VISUAL_ID:
			return getInterfacePort_3015Text(view);
		case InterfacePort4EditPart.VISUAL_ID:
			return getInterfacePort_3016Text(view);
		case EventPort3EditPart.VISUAL_ID:
			return getEventPort_3019Text(view);
		case EventPort4EditPart.VISUAL_ID:
			return getEventPort_3018Text(view);
		case SubcomponentEndpointEditPart.VISUAL_ID:
			return getSubcomponentEndpoint_4001Text(view);
		case ComponentEndpointEditPart.VISUAL_ID:
			return getComponentEndpoint_4002Text(view);
		}
		return getUnknownElementText(view);
	}

	/**
	 * @generated
	 */
	private String getCompositeStructure_1000Text(View view) {
		CompositeStructure domainModelElement = (CompositeStructure) view.getElement();
		if (domainModelElement != null) {
			return domainModelElement.getName();
		} else {
			SammDiagramEditorPlugin.getInstance().logError(
					"No domain element for view with visualID = " + 1000); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getCompositeComponent_2005Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.CompositeComponent_2005,
				view.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
						.getType(CompositeComponentNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5019); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getServiceArchitectureModel_2006Text(View view) {
		IParser parser = SammParserProvider.getParser(
				SammElementTypes.ServiceArchitectureModel_2006, view.getElement() != null ? view
						.getElement() : view, SammVisualIDRegistry
						.getType(ServiceArchitectureModelNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5020); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getSubcomponentInstance_3001Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.SubcomponentInstance_3001,
				view.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
						.getType(SubcomponentInstanceNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5006); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getInterfacePort_3011Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.InterfacePort_3011, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(InterfacePortNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5021); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getInterfacePort_3012Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.InterfacePort_3012, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(InterfacePortName2EditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5022); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getEventPort_3013Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.EventPort_3013, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(EventPortNameEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5023); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getEventPort_3014Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.EventPort_3014, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(EventPortName2EditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5024); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getSubcomponentInstance_3020Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.SubcomponentInstance_3020,
				view.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
						.getType(SubcomponentInstance2EditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 3020); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getConnector_3006Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.Connector_3006, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(WrappingLabelEditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5011); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getInterfacePort_3015Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.InterfacePort_3015, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(InterfacePortName3EditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5025); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getInterfacePort_3016Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.InterfacePort_3016, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(InterfacePortName4EditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5026); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getEventPort_3019Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.EventPort_3019, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(EventPortName3EditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5029); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getEventPort_3018Text(View view) {
		IParser parser = SammParserProvider.getParser(SammElementTypes.EventPort_3018, view
				.getElement() != null ? view.getElement() : view, SammVisualIDRegistry
				.getType(EventPortName4EditPart.VISUAL_ID));
		if (parser != null) {
			return parser.getPrintString(new EObjectAdapter(view.getElement() != null ? view
					.getElement() : view), ParserOptions.NONE.intValue());
		} else {
			SammDiagramEditorPlugin.getInstance()
					.logError("Parser was not found for label " + 5028); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getSubcomponentEndpoint_4001Text(View view) {
		SubcomponentEndpoint domainModelElement = (SubcomponentEndpoint) view.getElement();
		if (domainModelElement != null) {
			return domainModelElement.getId();
		} else {
			SammDiagramEditorPlugin.getInstance().logError(
					"No domain element for view with visualID = " + 4001); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getComponentEndpoint_4002Text(View view) {
		ComponentEndpoint domainModelElement = (ComponentEndpoint) view.getElement();
		if (domainModelElement != null) {
			return domainModelElement.getId();
		} else {
			SammDiagramEditorPlugin.getInstance().logError(
					"No domain element for view with visualID = " + 4002); //$NON-NLS-1$
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * @generated
	 */
	private String getUnknownElementText(View view) {
		return "<UnknownElement Visual_ID = " + view.getType() + ">"; //$NON-NLS-1$  //$NON-NLS-2$
	}

	/**
	 * @generated
	 */
	private String getUnresolvedDomainElementProxyText(View view) {
		return "<Unresolved domain element Visual_ID = " + view.getType() + ">"; //$NON-NLS-1$  //$NON-NLS-2$
	}

	/**
	 * @generated
	 */
	public void init(ICommonContentExtensionSite aConfig) {
	}

	/**
	 * @generated
	 */
	public void restoreState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public void saveState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public String getDescription(Object anElement) {
		return null;
	}

	/**
	 * @generated
	 */
	private boolean isOwnView(View view) {
		return CompositeStructureEditPart.MODEL_ID.equals(SammVisualIDRegistry.getModelID(view));
	}

}
