package eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies;

import java.util.Iterator;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.EventPort3CreateCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.EventPort4CreateCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.InterfacePort3CreateCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.InterfacePort4CreateCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.ComponentEndpointEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.ConnectorEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPort3EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPort4EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePort3EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePort4EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.ServiceArchitectureModelServiceArchitectureModelInnerCompartmentEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentEndpointEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentInstanceEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.composite.diagram.providers.SammElementTypes;

/**
 * @generated
 */
public class ServiceArchitectureModelItemSemanticEditPolicy extends SammBaseItemSemanticEditPolicy {

	/**
	 * @generated
	 */
	public ServiceArchitectureModelItemSemanticEditPolicy() {
		super(SammElementTypes.ServiceArchitectureModel_2006);
	}

	/**
	 * @generated
	 */
	protected Command getCreateCommand(CreateElementRequest req) {
		if (SammElementTypes.InterfacePort_3015 == req.getElementType()) {
			return getGEFWrapper(new InterfacePort3CreateCommand(req));
		}
		if (SammElementTypes.InterfacePort_3016 == req.getElementType()) {
			return getGEFWrapper(new InterfacePort4CreateCommand(req));
		}
		if (SammElementTypes.EventPort_3018 == req.getElementType()) {
			return getGEFWrapper(new EventPort4CreateCommand(req));
		}
		if (SammElementTypes.EventPort_3019 == req.getElementType()) {
			return getGEFWrapper(new EventPort3CreateCommand(req));
		}
		return super.getCreateCommand(req);
	}

	/**
	 * @generated
	 */
	protected Command getDestroyElementCommand(DestroyElementRequest req) {
		View view = (View) getHost().getModel();
		CompositeTransactionalCommand cmd = new CompositeTransactionalCommand(getEditingDomain(),
				null);
		cmd.setTransactionNestingEnabled(false);
		EAnnotation annotation = view.getEAnnotation("Shortcut"); //$NON-NLS-1$
		if (annotation == null) {
			// there are indirectly referenced children, need extra commands: false
			addDestroyChildNodesCommand(cmd);
			addDestroyShortcutsCommand(cmd, view);
			// delete host element
			cmd.add(new DestroyElementCommand(req));
		} else {
			cmd.add(new DeleteCommand(getEditingDomain(), view));
		}
		return getGEFWrapper(cmd.reduce());
	}

	/**
	 * @generated
	 */
	private void addDestroyChildNodesCommand(ICompositeCommand cmd) {
		View view = (View) getHost().getModel();
		for (Iterator nit = view.getChildren().iterator(); nit.hasNext();) {
			Node node = (Node) nit.next();
			switch (SammVisualIDRegistry.getVisualID(node)) {
			case InterfacePort3EditPart.VISUAL_ID:
				for (Iterator it = node.getTargetEdges().iterator(); it.hasNext();) {
					Edge incomingLink = (Edge) it.next();
					if (SammVisualIDRegistry.getVisualID(incomingLink) == SubcomponentEndpointEditPart.VISUAL_ID) {
						DestroyElementRequest r = new DestroyElementRequest(incomingLink
								.getElement(), false);
						cmd.add(new DestroyElementCommand(r));
						cmd.add(new DeleteCommand(getEditingDomain(), incomingLink));
						continue;
					}
					if (SammVisualIDRegistry.getVisualID(incomingLink) == ComponentEndpointEditPart.VISUAL_ID) {
						DestroyElementRequest r = new DestroyElementRequest(incomingLink
								.getElement(), false);
						cmd.add(new DestroyElementCommand(r));
						cmd.add(new DeleteCommand(getEditingDomain(), incomingLink));
						continue;
					}
				}
				/* @custom-gen 'artificial' semantic children InterfacePort and EventPort should not be deleted themselves,
				 only their connections need to be deleted (SubcomponentEndpoints) */
				// 	cmd.add(new org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand(new org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest(getEditingDomain(), node.getElement(), false))); // directlyOwned: true
				// don't need explicit deletion of node as parent's view deletion would clean child views as well 
				// cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), node));
				break;
			case InterfacePort4EditPart.VISUAL_ID:
				for (Iterator it = node.getTargetEdges().iterator(); it.hasNext();) {
					Edge incomingLink = (Edge) it.next();
					if (SammVisualIDRegistry.getVisualID(incomingLink) == SubcomponentEndpointEditPart.VISUAL_ID) {
						DestroyElementRequest r = new DestroyElementRequest(incomingLink
								.getElement(), false);
						cmd.add(new DestroyElementCommand(r));
						cmd.add(new DeleteCommand(getEditingDomain(), incomingLink));
						continue;
					}
					if (SammVisualIDRegistry.getVisualID(incomingLink) == ComponentEndpointEditPart.VISUAL_ID) {
						DestroyElementRequest r = new DestroyElementRequest(incomingLink
								.getElement(), false);
						cmd.add(new DestroyElementCommand(r));
						cmd.add(new DeleteCommand(getEditingDomain(), incomingLink));
						continue;
					}
				}
				/* @custom-gen 'artificial' semantic children InterfacePort and EventPort should not be deleted themselves,
				 only their connections need to be deleted (SubcomponentEndpoints) */
				// 	cmd.add(new org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand(new org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest(getEditingDomain(), node.getElement(), false))); // directlyOwned: true
				// don't need explicit deletion of node as parent's view deletion would clean child views as well 
				// cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), node));
				break;
			case EventPort4EditPart.VISUAL_ID:
				for (Iterator it = node.getTargetEdges().iterator(); it.hasNext();) {
					Edge incomingLink = (Edge) it.next();
					if (SammVisualIDRegistry.getVisualID(incomingLink) == SubcomponentEndpointEditPart.VISUAL_ID) {
						DestroyElementRequest r = new DestroyElementRequest(incomingLink
								.getElement(), false);
						cmd.add(new DestroyElementCommand(r));
						cmd.add(new DeleteCommand(getEditingDomain(), incomingLink));
						continue;
					}
					if (SammVisualIDRegistry.getVisualID(incomingLink) == ComponentEndpointEditPart.VISUAL_ID) {
						DestroyElementRequest r = new DestroyElementRequest(incomingLink
								.getElement(), false);
						cmd.add(new DestroyElementCommand(r));
						cmd.add(new DeleteCommand(getEditingDomain(), incomingLink));
						continue;
					}
				}
				/* @custom-gen 'artificial' semantic children InterfacePort and EventPort should not be deleted themselves,
				 only their connections need to be deleted (SubcomponentEndpoints) */
				// 	cmd.add(new org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand(new org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest(getEditingDomain(), node.getElement(), false))); // directlyOwned: true
				// don't need explicit deletion of node as parent's view deletion would clean child views as well 
				// cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), node));
				break;
			case EventPort3EditPart.VISUAL_ID:
				for (Iterator it = node.getTargetEdges().iterator(); it.hasNext();) {
					Edge incomingLink = (Edge) it.next();
					if (SammVisualIDRegistry.getVisualID(incomingLink) == SubcomponentEndpointEditPart.VISUAL_ID) {
						DestroyElementRequest r = new DestroyElementRequest(incomingLink
								.getElement(), false);
						cmd.add(new DestroyElementCommand(r));
						cmd.add(new DeleteCommand(getEditingDomain(), incomingLink));
						continue;
					}
					if (SammVisualIDRegistry.getVisualID(incomingLink) == ComponentEndpointEditPart.VISUAL_ID) {
						DestroyElementRequest r = new DestroyElementRequest(incomingLink
								.getElement(), false);
						cmd.add(new DestroyElementCommand(r));
						cmd.add(new DeleteCommand(getEditingDomain(), incomingLink));
						continue;
					}
				}
				/* @custom-gen 'artificial' semantic children InterfacePort and EventPort should not be deleted themselves,
				 only their connections need to be deleted (SubcomponentEndpoints) */
				// 	cmd.add(new org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand(new org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest(getEditingDomain(), node.getElement(), false))); // directlyOwned: true
				// don't need explicit deletion of node as parent's view deletion would clean child views as well 
				// cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), node));
				break;
			case ServiceArchitectureModelServiceArchitectureModelInnerCompartmentEditPart.VISUAL_ID:
				for (Iterator cit = node.getChildren().iterator(); cit.hasNext();) {
					Node cnode = (Node) cit.next();
					switch (SammVisualIDRegistry.getVisualID(cnode)) {
					case SubcomponentInstanceEditPart.VISUAL_ID:
						cmd.add(new DestroyElementCommand(new DestroyElementRequest(
								getEditingDomain(), cnode.getElement(), false))); // directlyOwned: true
						// don't need explicit deletion of cnode as parent's view deletion would clean child views as well 
						// cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), cnode));
						break;
					case ConnectorEditPart.VISUAL_ID:
						for (Iterator it = cnode.getSourceEdges().iterator(); it.hasNext();) {
							Edge outgoingLink = (Edge) it.next();
							if (SammVisualIDRegistry.getVisualID(outgoingLink) == SubcomponentEndpointEditPart.VISUAL_ID) {
								DestroyElementRequest r = new DestroyElementRequest(outgoingLink
										.getElement(), false);
								cmd.add(new DestroyElementCommand(r));
								cmd.add(new DeleteCommand(getEditingDomain(), outgoingLink));
								continue;
							}
							if (SammVisualIDRegistry.getVisualID(outgoingLink) == ComponentEndpointEditPart.VISUAL_ID) {
								DestroyElementRequest r = new DestroyElementRequest(outgoingLink
										.getElement(), false);
								cmd.add(new DestroyElementCommand(r));
								cmd.add(new DeleteCommand(getEditingDomain(), outgoingLink));
								continue;
							}
						}
						cmd.add(new DestroyElementCommand(new DestroyElementRequest(
								getEditingDomain(), cnode.getElement(), false))); // directlyOwned: true
						// don't need explicit deletion of cnode as parent's view deletion would clean child views as well 
						// cmd.add(new org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand(getEditingDomain(), cnode));
						break;
					}
				}
				break;
			}
		}
	}

}
