package eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies;

import java.util.Collections;
import java.util.Iterator;

import java.util.Map;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.helpers.SammBaseEditHelper;
import eu.qimpress.ide.editors.gmf.composite.diagram.expressions.SammAbstractExpression;
import eu.qimpress.ide.editors.gmf.composite.diagram.expressions.SammOCLFactory;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammDiagramEditorPlugin;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.composite.diagram.providers.SammElementTypes;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;

/**
 * @generated
 */
public class SammBaseItemSemanticEditPolicy extends SemanticEditPolicy {

	/**
	 * Extended request data key to hold editpart visual id.
	 * @generated
	 */
	public static final String VISUAL_ID_KEY = "visual_id"; //$NON-NLS-1$

	/**
	 * @generated
	 */
	private final IElementType myElementType;

	/**
	 * @generated
	 */
	protected SammBaseItemSemanticEditPolicy(IElementType elementType) {
		myElementType = elementType;
	}

	/**
	 * Extended request data key to hold editpart visual id.
	 * Add visual id of edited editpart to extended data of the request
	 * so command switch can decide what kind of diagram element is being edited.
	 * It is done in those cases when it's not possible to deduce diagram
	 * element kind from domain element.
	 * 
	 * @generated
	 */
	public Command getCommand(Request request) {
		if (request instanceof ReconnectRequest) {
			Object view = ((ReconnectRequest) request).getConnectionEditPart().getModel();
			if (view instanceof View) {
				Integer id = new Integer(SammVisualIDRegistry.getVisualID((View) view));
				request.getExtendedData().put(VISUAL_ID_KEY, id);
			}
		}
		return super.getCommand(request);
	}

	/**
	 * Returns visual id from request parameters.
	 * @generated
	 */
	protected int getVisualID(IEditCommandRequest request) {
		Object id = request.getParameter(VISUAL_ID_KEY);
		return id instanceof Integer ? ((Integer) id).intValue() : -1;
	}

	/**
	 * @generated
	 */
	protected Command getSemanticCommand(IEditCommandRequest request) {
		IEditCommandRequest completedRequest = completeRequest(request);
		Command semanticCommand = getSemanticCommandSwitch(completedRequest);
		semanticCommand = getEditHelperCommand(completedRequest, semanticCommand);
		if (completedRequest instanceof DestroyRequest) {
			DestroyRequest destroyRequest = (DestroyRequest) completedRequest;
			return shouldProceed(destroyRequest) ? addDeleteViewCommand(semanticCommand,
					destroyRequest) : null;
		}
		return semanticCommand;
	}

	/**
	 * @generated
	 */
	protected Command addDeleteViewCommand(Command mainCommand, DestroyRequest completedRequest) {
		Command deleteViewCommand = getGEFWrapper(new DeleteCommand(getEditingDomain(),
				(View) getHost().getModel()));
		return mainCommand == null ? deleteViewCommand : mainCommand.chain(deleteViewCommand);
	}

	/**
	 * @generated
	 */
	private Command getEditHelperCommand(IEditCommandRequest request, Command editPolicyCommand) {
		if (editPolicyCommand != null) {
			ICommand command = editPolicyCommand instanceof ICommandProxy ? ((ICommandProxy) editPolicyCommand)
					.getICommand()
					: new CommandProxy(editPolicyCommand);
			request.setParameter(SammBaseEditHelper.EDIT_POLICY_COMMAND, command);
		}
		IElementType requestContextElementType = getContextElementType(request);
		request.setParameter(SammBaseEditHelper.CONTEXT_ELEMENT_TYPE, requestContextElementType);
		ICommand command = requestContextElementType.getEditCommand(request);
		request.setParameter(SammBaseEditHelper.EDIT_POLICY_COMMAND, null);
		request.setParameter(SammBaseEditHelper.CONTEXT_ELEMENT_TYPE, null);
		if (command != null) {
			if (!(command instanceof CompositeTransactionalCommand)) {
				command = new CompositeTransactionalCommand(getEditingDomain(), command.getLabel())
						.compose(command);
			}
			return new ICommandProxy(command);
		}
		return editPolicyCommand;
	}

	/**
	 * @generated
	 */
	private IElementType getContextElementType(IEditCommandRequest request) {
		IElementType requestContextElementType = SammElementTypes
				.getElementType(getVisualID(request));
		return requestContextElementType != null ? requestContextElementType : myElementType;
	}

	/**
	 * @generated
	 */
	protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
		if (req instanceof CreateRelationshipRequest) {
			return getCreateRelationshipCommand((CreateRelationshipRequest) req);
		} else if (req instanceof CreateElementRequest) {
			return getCreateCommand((CreateElementRequest) req);
		} else if (req instanceof ConfigureRequest) {
			return getConfigureCommand((ConfigureRequest) req);
		} else if (req instanceof DestroyElementRequest) {
			return getDestroyElementCommand((DestroyElementRequest) req);
		} else if (req instanceof DestroyReferenceRequest) {
			return getDestroyReferenceCommand((DestroyReferenceRequest) req);
		} else if (req instanceof DuplicateElementsRequest) {
			return getDuplicateCommand((DuplicateElementsRequest) req);
		} else if (req instanceof GetEditContextRequest) {
			return getEditContextCommand((GetEditContextRequest) req);
		} else if (req instanceof MoveRequest) {
			return getMoveCommand((MoveRequest) req);
		} else if (req instanceof ReorientReferenceRelationshipRequest) {
			return getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest) req);
		} else if (req instanceof ReorientRelationshipRequest) {
			return getReorientRelationshipCommand((ReorientRelationshipRequest) req);
		} else if (req instanceof SetRequest) {
			return getSetCommand((SetRequest) req);
		}
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getConfigureCommand(ConfigureRequest req) {
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getCreateCommand(CreateElementRequest req) {
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getSetCommand(SetRequest req) {
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getEditContextCommand(GetEditContextRequest req) {
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getDestroyElementCommand(DestroyElementRequest req) {
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getDuplicateCommand(DuplicateElementsRequest req) {
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getMoveCommand(MoveRequest req) {
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getReorientReferenceRelationshipCommand(
			ReorientReferenceRelationshipRequest req) {
		return UnexecutableCommand.INSTANCE;
	}

	/**
	 * @generated
	 */
	protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
		return UnexecutableCommand.INSTANCE;
	}

	/**
	 * @generated
	 */
	protected final Command getGEFWrapper(ICommand cmd) {
		return new ICommandProxy(cmd);
	}

	/**
	 * Returns editing domain from the host edit part.
	 * @generated
	 */
	protected TransactionalEditingDomain getEditingDomain() {
		return ((IGraphicalEditPart) getHost()).getEditingDomain();
	}

	/**
	 * Clean all shortcuts to the host element from the same diagram
	 * @generated
	 */
	protected void addDestroyShortcutsCommand(ICompositeCommand cmd, View view) {
		assert view.getEAnnotation("Shortcut") == null; //$NON-NLS-1$
		for (Iterator it = view.getDiagram().getChildren().iterator(); it.hasNext();) {
			View nextView = (View) it.next();
			if (nextView.getEAnnotation("Shortcut") == null || !nextView.isSetElement() || nextView.getElement() != view.getElement()) { //$NON-NLS-1$
				continue;
			}
			cmd.add(new DeleteCommand(getEditingDomain(), nextView));
		}
	}

	/**
	 * @generated
	 */
	public static class LinkConstraints {

		/**
		 * @generated
		 */
		private static final String OPPOSITE_END_VAR = "oppositeEnd"; //$NON-NLS-1$

		/**
		 * @generated
		 */
		private static SammAbstractExpression SubcomponentEndpoint_4001_SourceExpression;

		/**
		 * @generated
		 */
		private static SammAbstractExpression ComponentEndpoint_4002_SourceExpression;

		/**
		 * @generated
		 */
		private static SammAbstractExpression ComponentEndpoint_4002_TargetExpression;

		/**
		 * @generated
		 */
		public static boolean canCreateSubcomponentEndpoint_4001(Connector source, Port target) {
			return canExistSubcomponentEndpoint_4001(source, target);
		}

		/**
		 * @generated
		 */
		public static boolean canCreateComponentEndpoint_4002(Connector source, Port target) {
			return canExistComponentEndpoint_4002(source, target);
		}

		/**
		 * @generated
		 */
		public static boolean canExistSubcomponentEndpoint_4001(Connector source, Port target) {
			try {

				/*
				  @custom-gen check constraint if the element is not null, otherwise
				        move on with the next constraint to perform validation
				        of source and target element constraints independently
				        (/templates/aspects/xpt/diagram/editpolicies/BaseItemSemanticEditPolicy.xpt)
				 */
				if (source != null) {
					if (SubcomponentEndpoint_4001_SourceExpression == null) {
						Map env = Collections.singletonMap(OPPOSITE_END_VAR,
								StaticstructurePackage.eINSTANCE.getPort());
						SubcomponentEndpoint_4001_SourceExpression = SammOCLFactory
								.getExpression(
										"-- if target port has been already selected\r\noppositeEnd <> null implies \r\n-- then its enclosing ComponentType should not be the same as the connector\'s parent (port of a SubcomponentInstance)\r\n(oppositeEnd.oclAsType(ecore::EObject).eContainer() <> self.oclAsType(ecore::EObject).eContainer() and \r\n-- and no other endpoint should point to this port (port is not bound yet)\r\n\n(not self.oclAsType(ecore::EObject).eContainer().oclAsType(CompositeStructure).connector->exists(endpoints->exists(port = oppositeEnd))) \r\n-- except the target port is a provided port (which can be connected to multiple requiring ports) \r\nor (oppositeEnd.oclIsKindOf(InterfacePort) implies not oppositeEnd.oclAsType(InterfacePort).isRequired)\r\n-- except the target port is an event port\r\n-- TODO: clarify event connector semantics\r\nor oppositeEnd.oclIsKindOf(EventPort))", StaticstructurePackage.eINSTANCE.getConnector(), env); //$NON-NLS-1$
					}
					Object sourceVal = SubcomponentEndpoint_4001_SourceExpression.evaluate(source,
							Collections.singletonMap(OPPOSITE_END_VAR, target));
					if (false == sourceVal instanceof Boolean
							|| !((Boolean) sourceVal).booleanValue()) {
						return false;
					} // else fall-through
				}
				return true;
			} catch (Exception e) {
				SammDiagramEditorPlugin.getInstance().logError(
						"Link constraint evaluation error", e); //$NON-NLS-1$
				return false;
			}
		}

		/**
		 * @generated
		 */
		public static boolean canExistComponentEndpoint_4002(Connector source, Port target) {
			try {

				/*
				  @custom-gen check constraint if the element is not null, otherwise
				        move on with the next constraint to perform validation
				        of source and target element constraints independently
				        (/templates/aspects/xpt/diagram/editpolicies/BaseItemSemanticEditPolicy.xpt)
				 */
				if (source != null) {
					if (ComponentEndpoint_4002_SourceExpression == null) {
						Map env = Collections.singletonMap(OPPOSITE_END_VAR,
								StaticstructurePackage.eINSTANCE.getPort());
						ComponentEndpoint_4002_SourceExpression = SammOCLFactory
								.getExpression(
										"-- source connector should not have any other ComponentEndpoints\r\nnot self.endpoints->exists(oclIsKindOf(ComponentEndpoint))\r and\r\n-- and the target port\'s enclosing ComponetType should be the same as the connector\'s parent (external Port)\r\n(oppositeEnd <> null implies (oppositeEnd.oclAsType(ecore::EObject).eContainer() = self.oclAsType(ecore::EObject).eContainer()))", StaticstructurePackage.eINSTANCE.getConnector(), env); //$NON-NLS-1$
					}
					Object sourceVal = ComponentEndpoint_4002_SourceExpression.evaluate(source,
							Collections.singletonMap(OPPOSITE_END_VAR, target));
					if (false == sourceVal instanceof Boolean
							|| !((Boolean) sourceVal).booleanValue()) {
						return false;
					} // else fall-through
				}

				/*
				  @custom-gen check constraint if the element is not null, otherwise
				        move on with the next constraint to perform validation
				        of source and target element constraints independently
				        (/templates/aspects/xpt/diagram/editpolicies/BaseItemSemanticEditPolicy.xpt)
				 */
				if (target != null) {
					if (ComponentEndpoint_4002_TargetExpression == null) {
						Map env = Collections.singletonMap(OPPOSITE_END_VAR,
								StaticstructurePackage.eINSTANCE.getConnector());
						ComponentEndpoint_4002_TargetExpression = SammOCLFactory
								.getExpression(
										"-- for the target port there is no existing endpoint referencing it (port is not bound yet)\r\nnot self.oclAsType(ecore::EObject).eContainer().oclAsType(CompositeStructure).connector->exists(endpoints->exists(port = self)) \r\n-- except it is required interface port (which can be connected to multiple inner components)\r\nor (self.oclIsKindOf(InterfacePort) implies self.oclAsType(InterfacePort).isRequired)\r\r\n\r-- TODO: clarify event connector semantics \r\n-- or it is an EventPort\r\n \n\nor self.oclIsKindOf(EventPort)", StaticstructurePackage.eINSTANCE.getPort(), env); //$NON-NLS-1$
					}
					Object targetVal = ComponentEndpoint_4002_TargetExpression.evaluate(target,
							Collections.singletonMap(OPPOSITE_END_VAR, source));
					if (false == targetVal instanceof Boolean
							|| !((Boolean) targetVal).booleanValue()) {
						return false;
					} // else fall-through
				}
				return true;
			} catch (Exception e) {
				SammDiagramEditorPlugin.getInstance().logError(
						"Link constraint evaluation error", e); //$NON-NLS-1$
				return false;
			}
		}
	}

}
