package eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies;

import java.util.Iterator;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.ComponentEndpointCreateCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.ComponentEndpointReorientCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.SubcomponentEndpointCreateCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.SubcomponentEndpointReorientCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.ComponentEndpointEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentEndpointEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.composite.diagram.providers.SammElementTypes;

/**
 * @generated
 */
public class InterfacePort4ItemSemanticEditPolicy extends SammBaseItemSemanticEditPolicy {

	/**
	 * @generated
	 */
	public InterfacePort4ItemSemanticEditPolicy() {
		super(SammElementTypes.InterfacePort_3016);
	}

	/**
	 * @generated
	 */
	protected Command getDestroyElementCommand(DestroyElementRequest req) {
		View view = (View) getHost().getModel();
		CompositeTransactionalCommand cmd = new CompositeTransactionalCommand(getEditingDomain(),
				null);
		cmd.setTransactionNestingEnabled(false);
		for (Iterator it = view.getTargetEdges().iterator(); it.hasNext();) {
			Edge incomingLink = (Edge) it.next();
			if (SammVisualIDRegistry.getVisualID(incomingLink) == SubcomponentEndpointEditPart.VISUAL_ID) {
				DestroyElementRequest r = new DestroyElementRequest(incomingLink.getElement(),
						false);
				cmd.add(new DestroyElementCommand(r));
				cmd.add(new DeleteCommand(getEditingDomain(), incomingLink));
				continue;
			}
			if (SammVisualIDRegistry.getVisualID(incomingLink) == ComponentEndpointEditPart.VISUAL_ID) {
				DestroyElementRequest r = new DestroyElementRequest(incomingLink.getElement(),
						false);
				cmd.add(new DestroyElementCommand(r));
				cmd.add(new DeleteCommand(getEditingDomain(), incomingLink));
				continue;
			}
		}
		EAnnotation annotation = view.getEAnnotation("Shortcut"); //$NON-NLS-1$
		if (annotation == null) {
			// there are indirectly referenced children, need extra commands: false
			addDestroyShortcutsCommand(cmd, view);
			// delete host element
			cmd.add(new DestroyElementCommand(req));
		} else {
			cmd.add(new DeleteCommand(getEditingDomain(), view));
		}
		return getGEFWrapper(cmd.reduce());
	}

	/**
	 * @generated
	 */
	protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
		Command command = req.getTarget() == null ? getStartCreateRelationshipCommand(req)
				: getCompleteCreateRelationshipCommand(req);
		return command != null ? command : super.getCreateRelationshipCommand(req);
	}

	/**
	 * @generated
	 */
	protected Command getStartCreateRelationshipCommand(CreateRelationshipRequest req) {
		if (SammElementTypes.SubcomponentEndpoint_4001 == req.getElementType()) {
			return getGEFWrapper(new SubcomponentEndpointCreateCommand(req, req.getTarget(), req
					.getSource()));
		}
		if (SammElementTypes.ComponentEndpoint_4002 == req.getElementType()) {
			return getGEFWrapper(new ComponentEndpointCreateCommand(req, req.getTarget(), req
					.getSource()));
		}
		return null;
	}

	/**
	 * @generated
	 */
	protected Command getCompleteCreateRelationshipCommand(CreateRelationshipRequest req) {
		if (SammElementTypes.SubcomponentEndpoint_4001 == req.getElementType()) {
			return getGEFWrapper(new SubcomponentEndpointCreateCommand(req, req.getSource(), req
					.getTarget()));
		}
		if (SammElementTypes.ComponentEndpoint_4002 == req.getElementType()) {
			return getGEFWrapper(new ComponentEndpointCreateCommand(req, req.getSource(), req
					.getTarget()));
		}
		return null;
	}

	/**
	 * Returns command to reorient EClass based link. New link target or source
	 * should be the domain model element associated with this node.
	 * 
	 * @generated
	 */
	protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
		switch (getVisualID(req)) {
		case SubcomponentEndpointEditPart.VISUAL_ID:
			return getGEFWrapper(new SubcomponentEndpointReorientCommand(req));
		case ComponentEndpointEditPart.VISUAL_ID:
			return getGEFWrapper(new ComponentEndpointReorientCommand(req));
		}
		return super.getReorientRelationshipCommand(req);
	}

}
