package eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts;

import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies.ServiceArchitectureModelCanonicalEditPolicy;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies.ServiceArchitectureModelItemSemanticEditPolicy;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammVisualIDRegistry;

/**
 * @generated
 */
public class ServiceArchitectureModelEditPart extends AbstractBorderedShapeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 2006;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public ServiceArchitectureModelEditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		installEditPolicy(EditPolicyRoles.CREATION_ROLE, new CreationEditPolicy());
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new ServiceArchitectureModelItemSemanticEditPolicy());
		installEditPolicy(EditPolicyRoles.DRAG_DROP_ROLE, new DragDropEditPolicy());
		installEditPolicy(EditPolicyRoles.CANONICAL_ROLE,
				new ServiceArchitectureModelCanonicalEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
		// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies
		// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		LayoutEditPolicy lep = new LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				View childView = (View) child.getModel();
				switch (SammVisualIDRegistry.getVisualID(childView)) {
				case InterfacePort3EditPart.VISUAL_ID:
				case InterfacePort4EditPart.VISUAL_ID:
				case EventPort4EditPart.VISUAL_ID:
				case EventPort3EditPart.VISUAL_ID:
					return new BorderItemSelectionEditPolicy();
				}
				EditPolicy result = child.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		ServiceArchitectureModelFigure figure = new ServiceArchitectureModelFigure();
		return primaryShape = figure;
	}

	/**
	 * @generated
	 */
	public ServiceArchitectureModelFigure getPrimaryShape() {
		return (ServiceArchitectureModelFigure) primaryShape;
	}

	/**
	 * @generated
	 */
	protected boolean addFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof ServiceArchitectureModelNameEditPart) {
			((ServiceArchitectureModelNameEditPart) childEditPart).setLabel(getPrimaryShape()
					.getFigureCompositeStructureNameLabelFigure());
			return true;
		}
		if (childEditPart instanceof ServiceArchitectureModelServiceArchitectureModelInnerCompartmentEditPart) {
			IFigure pane = getPrimaryShape().getFigureCompositeStructureInnerCompartmentFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane
					.add(((ServiceArchitectureModelServiceArchitectureModelInnerCompartmentEditPart) childEditPart)
							.getFigure());
			return true;
		}
		if (childEditPart instanceof InterfacePort3EditPart) {
			BorderItemLocator locator = new BorderItemLocator(getMainFigure(),
					PositionConstants.WEST);
			getBorderedFigure().getBorderItemContainer().add(
					((InterfacePort3EditPart) childEditPart).getFigure(), locator);
			return true;
		}
		if (childEditPart instanceof InterfacePort4EditPart) {
			BorderItemLocator locator = new BorderItemLocator(getMainFigure(),
					PositionConstants.EAST);
			getBorderedFigure().getBorderItemContainer().add(
					((InterfacePort4EditPart) childEditPart).getFigure(), locator);
			return true;
		}
		if (childEditPart instanceof EventPort4EditPart) {
			BorderItemLocator locator = new BorderItemLocator(getMainFigure(),
					PositionConstants.NORTH);
			getBorderedFigure().getBorderItemContainer().add(
					((EventPort4EditPart) childEditPart).getFigure(), locator);
			return true;
		}
		if (childEditPart instanceof EventPort3EditPart) {
			BorderItemLocator locator = new BorderItemLocator(getMainFigure(),
					PositionConstants.SOUTH);
			getBorderedFigure().getBorderItemContainer().add(
					((EventPort3EditPart) childEditPart).getFigure(), locator);
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected boolean removeFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof ServiceArchitectureModelNameEditPart) {
			return true;
		}
		if (childEditPart instanceof ServiceArchitectureModelServiceArchitectureModelInnerCompartmentEditPart) {
			IFigure pane = getPrimaryShape().getFigureCompositeStructureInnerCompartmentFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane
					.remove(((ServiceArchitectureModelServiceArchitectureModelInnerCompartmentEditPart) childEditPart)
							.getFigure());
			return true;
		}
		if (childEditPart instanceof InterfacePort3EditPart) {
			getBorderedFigure().getBorderItemContainer().remove(
					((InterfacePort3EditPart) childEditPart).getFigure());
			return true;
		}
		if (childEditPart instanceof InterfacePort4EditPart) {
			getBorderedFigure().getBorderItemContainer().remove(
					((InterfacePort4EditPart) childEditPart).getFigure());
			return true;
		}
		if (childEditPart instanceof EventPort4EditPart) {
			getBorderedFigure().getBorderItemContainer().remove(
					((EventPort4EditPart) childEditPart).getFigure());
			return true;
		}
		if (childEditPart instanceof EventPort3EditPart) {
			getBorderedFigure().getBorderItemContainer().remove(
					((EventPort3EditPart) childEditPart).getFigure());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected void addChildVisual(EditPart childEditPart, int index) {
		if (addFixedChild(childEditPart)) {
			return;
		}
		super.addChildVisual(childEditPart, -1);
	}

	/**
	 * @generated
	 */
	protected void removeChildVisual(EditPart childEditPart) {
		if (removeFixedChild(childEditPart)) {
			return;
		}
		super.removeChildVisual(childEditPart);
	}

	/**
	 * @generated
	 */
	protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
		if (editPart instanceof ServiceArchitectureModelServiceArchitectureModelInnerCompartmentEditPart) {
			return getPrimaryShape().getFigureCompositeStructureInnerCompartmentFigure();
		}
		if (editPart instanceof IBorderItemEditPart) {
			return getBorderedFigure().getBorderItemContainer();
		}
		return getContentPane();
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
		return result;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createMainFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(5);
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	protected void setForegroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setForegroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setBackgroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setBackgroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineWidth(int width) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineWidth(width);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineType(int style) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineStyle(style);
		}
	}

	/**
	 * @generated
	 */
	public EditPart getPrimaryChildEditPart() {
		return getChildBySemanticHint(SammVisualIDRegistry
				.getType(ServiceArchitectureModelNameEditPart.VISUAL_ID));
	}

	/**
	 * @generated
	 */
	public class ServiceArchitectureModelFigure extends RectangleFigure {

		/**
		 * @generated
		 */
		private WrappingLabel fFigureCompositeStructureNameLabelFigure;
		/**
		 * @generated
		 */
		private WrappingLabel fFigureCompositeStructureStereotypeLabelFigure;
		/**
		 * @generated
		 */
		private RectangleFigure fFigureCompositeStructureInnerCompartmentFigure;

		/**
		 * @generated
		 */
		public ServiceArchitectureModelFigure() {

			GridLayout layoutThis = new GridLayout();
			layoutThis.numColumns = 1;
			layoutThis.makeColumnsEqualWidth = true;
			layoutThis.horizontalSpacing = 0;
			layoutThis.verticalSpacing = 0;
			layoutThis.marginWidth = 0;
			layoutThis.marginHeight = 0;
			this.setLayoutManager(layoutThis);

			this.setLineWidth(1);
			createContents();
		}

		/**
		 * @generated
		 */
		private void createContents() {

			fFigureCompositeStructureStereotypeLabelFigure = new WrappingLabel();
			fFigureCompositeStructureStereotypeLabelFigure.setText("<<ServiceArchitectureModel>>");

			GridData constraintFFigureCompositeStructureStereotypeLabelFigure = new GridData();
			constraintFFigureCompositeStructureStereotypeLabelFigure.verticalAlignment = GridData.CENTER;
			constraintFFigureCompositeStructureStereotypeLabelFigure.horizontalAlignment = GridData.CENTER;
			constraintFFigureCompositeStructureStereotypeLabelFigure.horizontalIndent = 0;
			constraintFFigureCompositeStructureStereotypeLabelFigure.horizontalSpan = 1;
			constraintFFigureCompositeStructureStereotypeLabelFigure.verticalSpan = 1;
			constraintFFigureCompositeStructureStereotypeLabelFigure.grabExcessHorizontalSpace = true;
			constraintFFigureCompositeStructureStereotypeLabelFigure.grabExcessVerticalSpace = false;
			this.add(fFigureCompositeStructureStereotypeLabelFigure,
					constraintFFigureCompositeStructureStereotypeLabelFigure);

			fFigureCompositeStructureNameLabelFigure = new WrappingLabel();
			fFigureCompositeStructureNameLabelFigure.setText("");

			GridData constraintFFigureCompositeStructureNameLabelFigure = new GridData();
			constraintFFigureCompositeStructureNameLabelFigure.verticalAlignment = GridData.CENTER;
			constraintFFigureCompositeStructureNameLabelFigure.horizontalAlignment = GridData.CENTER;
			constraintFFigureCompositeStructureNameLabelFigure.horizontalIndent = 0;
			constraintFFigureCompositeStructureNameLabelFigure.horizontalSpan = 1;
			constraintFFigureCompositeStructureNameLabelFigure.verticalSpan = 1;
			constraintFFigureCompositeStructureNameLabelFigure.grabExcessHorizontalSpace = true;
			constraintFFigureCompositeStructureNameLabelFigure.grabExcessVerticalSpace = false;
			this.add(fFigureCompositeStructureNameLabelFigure,
					constraintFFigureCompositeStructureNameLabelFigure);

			fFigureCompositeStructureInnerCompartmentFigure = new RectangleFigure();
			fFigureCompositeStructureInnerCompartmentFigure.setFill(false);
			fFigureCompositeStructureInnerCompartmentFigure.setLineWidth(1);

			GridData constraintFFigureCompositeStructureInnerCompartmentFigure = new GridData();
			constraintFFigureCompositeStructureInnerCompartmentFigure.verticalAlignment = GridData.FILL;
			constraintFFigureCompositeStructureInnerCompartmentFigure.horizontalAlignment = GridData.FILL;
			constraintFFigureCompositeStructureInnerCompartmentFigure.horizontalIndent = 0;
			constraintFFigureCompositeStructureInnerCompartmentFigure.horizontalSpan = 1;
			constraintFFigureCompositeStructureInnerCompartmentFigure.verticalSpan = 1;
			constraintFFigureCompositeStructureInnerCompartmentFigure.grabExcessHorizontalSpace = true;
			constraintFFigureCompositeStructureInnerCompartmentFigure.grabExcessVerticalSpace = true;
			this.add(fFigureCompositeStructureInnerCompartmentFigure,
					constraintFFigureCompositeStructureInnerCompartmentFigure);

		}

		/**
		 * @generated
		 */
		private boolean myUseLocalCoordinates = false;

		/**
		 * @generated
		 */
		protected boolean useLocalCoordinates() {
			return myUseLocalCoordinates;
		}

		/**
		 * @generated
		 */
		protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
			myUseLocalCoordinates = useLocalCoordinates;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureCompositeStructureNameLabelFigure() {
			return fFigureCompositeStructureNameLabelFigure;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureCompositeStructureStereotypeLabelFigure() {
			return fFigureCompositeStructureStereotypeLabelFigure;
		}

		/**
		 * @generated
		 */
		public RectangleFigure getFigureCompositeStructureInnerCompartmentFigure() {
			return fFigureCompositeStructureInnerCompartmentFigure;
		}

	}

}
