package eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;

import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammVisualIDRegistry;

/**
 * @generated
 */
public class SammEditPartFactory implements EditPartFactory {

	/**
	 * @generated
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		if (model instanceof View) {
			View view = (View) model;
			switch (SammVisualIDRegistry.getVisualID(view)) {

			case CompositeStructureEditPart.VISUAL_ID:
				return new CompositeStructureEditPart(view);

			case CompositeComponentEditPart.VISUAL_ID:
				return new CompositeComponentEditPart(view);

			case CompositeComponentNameEditPart.VISUAL_ID:
				return new CompositeComponentNameEditPart(view);

			case ServiceArchitectureModelEditPart.VISUAL_ID:
				return new ServiceArchitectureModelEditPart(view);

			case ServiceArchitectureModelNameEditPart.VISUAL_ID:
				return new ServiceArchitectureModelNameEditPart(view);

			case SubcomponentInstanceEditPart.VISUAL_ID:
				return new SubcomponentInstanceEditPart(view);

			case SubcomponentInstanceNameEditPart.VISUAL_ID:
				return new SubcomponentInstanceNameEditPart(view);

			case InterfacePortEditPart.VISUAL_ID:
				return new InterfacePortEditPart(view);

			case InterfacePortNameEditPart.VISUAL_ID:
				return new InterfacePortNameEditPart(view);

			case InterfacePort2EditPart.VISUAL_ID:
				return new InterfacePort2EditPart(view);

			case InterfacePortName2EditPart.VISUAL_ID:
				return new InterfacePortName2EditPart(view);

			case EventPortEditPart.VISUAL_ID:
				return new EventPortEditPart(view);

			case EventPortNameEditPart.VISUAL_ID:
				return new EventPortNameEditPart(view);

			case EventPort2EditPart.VISUAL_ID:
				return new EventPort2EditPart(view);

			case EventPortName2EditPart.VISUAL_ID:
				return new EventPortName2EditPart(view);

			case SubcomponentInstance2EditPart.VISUAL_ID:
				return new SubcomponentInstance2EditPart(view);

			case ConnectorEditPart.VISUAL_ID:
				return new ConnectorEditPart(view);

			case WrappingLabelEditPart.VISUAL_ID:
				return new WrappingLabelEditPart(view);

			case InterfacePort3EditPart.VISUAL_ID:
				return new InterfacePort3EditPart(view);

			case InterfacePortName3EditPart.VISUAL_ID:
				return new InterfacePortName3EditPart(view);

			case InterfacePort4EditPart.VISUAL_ID:
				return new InterfacePort4EditPart(view);

			case InterfacePortName4EditPart.VISUAL_ID:
				return new InterfacePortName4EditPart(view);

			case EventPort3EditPart.VISUAL_ID:
				return new EventPort3EditPart(view);

			case EventPortName3EditPart.VISUAL_ID:
				return new EventPortName3EditPart(view);

			case EventPort4EditPart.VISUAL_ID:
				return new EventPort4EditPart(view);

			case EventPortName4EditPart.VISUAL_ID:
				return new EventPortName4EditPart(view);

			case CompositeComponentCompositeStructureInnerCompartmentEditPart.VISUAL_ID:
				return new CompositeComponentCompositeStructureInnerCompartmentEditPart(view);

			case SubcomponentInstanceSubcomponentListEditPart.VISUAL_ID:
				return new SubcomponentInstanceSubcomponentListEditPart(view);

			case ServiceArchitectureModelServiceArchitectureModelInnerCompartmentEditPart.VISUAL_ID:
				return new ServiceArchitectureModelServiceArchitectureModelInnerCompartmentEditPart(
						view);

			case SubcomponentEndpointEditPart.VISUAL_ID:
				return new SubcomponentEndpointEditPart(view);

			case ComponentEndpointEditPart.VISUAL_ID:
				return new ComponentEndpointEditPart(view);

			}
		}
		return createUnrecognizedEditPart(context, model);
	}

	/**
	 * @generated
	 */
	private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
		// Handle creation of unrecognized child node EditParts here
		return null;
	}

	/**
	 * @generated
	 */
	public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
		if (source.getFigure() instanceof WrappingLabel)
			return new TextCellEditorLocator((WrappingLabel) source.getFigure());
		else {
			return new LabelCellEditorLocator((Label) source.getFigure());
		}
	}

	/**
	 * @generated
	 */
	static private class TextCellEditorLocator implements CellEditorLocator {

		/**
		 * @generated
		 */
		private WrappingLabel wrapLabel;

		/**
		 * @generated
		 */
		public TextCellEditorLocator(WrappingLabel wrapLabel) {
			this.wrapLabel = wrapLabel;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getWrapLabel() {
			return wrapLabel;
		}

		/**
		 * @generated
		 */
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			Rectangle rect = getWrapLabel().getTextBounds().getCopy();
			getWrapLabel().translateToAbsolute(rect);
			if (getWrapLabel().isTextWrapOn() && getWrapLabel().getText().length() > 0) {
				rect.setSize(new Dimension(text.computeSize(rect.width, SWT.DEFAULT)));
			} else {
				int avr = FigureUtilities.getFontMetrics(text.getFont()).getAverageCharWidth();
				rect.setSize(new Dimension(text.computeSize(SWT.DEFAULT, SWT.DEFAULT)).expand(
						avr * 2, 0));
			}
			if (!rect.equals(new Rectangle(text.getBounds()))) {
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
			}
		}
	}

	/**
	 * @generated
	 */
	private static class LabelCellEditorLocator implements CellEditorLocator {

		/**
		 * @generated
		 */
		private Label label;

		/**
		 * @generated
		 */
		public LabelCellEditorLocator(Label label) {
			this.label = label;
		}

		/**
		 * @generated
		 */
		public Label getLabel() {
			return label;
		}

		/**
		 * @generated
		 */
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			Rectangle rect = getLabel().getTextBounds().getCopy();
			getLabel().translateToAbsolute(rect);
			int avr = FigureUtilities.getFontMetrics(text.getFont()).getAverageCharWidth();
			rect.setSize(new Dimension(text.computeSize(SWT.DEFAULT, SWT.DEFAULT)).expand(avr * 2,
					0));
			if (!rect.equals(new Rectangle(text.getBounds()))) {
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
			}
		}
	}
}
