package eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies.ConnectorGraphicalNodeEditPolicy;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies.ConnectorItemSemanticEditPolicy;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.composite.diagram.providers.SammElementTypes;

/**
 * @generated
 */
public class ConnectorEditPart extends ShapeNodeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 3006;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public ConnectorEditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE, new ConnectorItemSemanticEditPolicy());
		installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE, new ConnectorGraphicalNodeEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
		// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies
		// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		LayoutEditPolicy lep = new LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				EditPolicy result = child.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		ConnectorFigure figure = new ConnectorFigure();
		return primaryShape = figure;
	}

	/**
	 * @generated
	 */
	public ConnectorFigure getPrimaryShape() {
		return (ConnectorFigure) primaryShape;
	}

	/**
	 * @generated
	 */
	protected boolean addFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof WrappingLabelEditPart) {
			((WrappingLabelEditPart) childEditPart).setLabel(getPrimaryShape()
					.getFigureConnectorIconLabelFigure());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected boolean removeFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof WrappingLabelEditPart) {
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected void addChildVisual(EditPart childEditPart, int index) {
		if (addFixedChild(childEditPart)) {
			return;
		}
		super.addChildVisual(childEditPart, -1);
	}

	/**
	 * @generated
	 */
	protected void removeChildVisual(EditPart childEditPart) {
		if (removeFixedChild(childEditPart)) {
			return;
		}
		super.removeChildVisual(childEditPart);
	}

	/**
	 * @generated
	 */
	protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
		return getContentPane();
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(17, 17);
		return result;
	}

	/**
	 * @generated
	 */
	public EditPolicy getPrimaryDragEditPolicy() {
		EditPolicy result = super.getPrimaryDragEditPolicy();
		if (result instanceof ResizableEditPolicy) {
			ResizableEditPolicy ep = (ResizableEditPolicy) result;
			ep.setResizeDirections(PositionConstants.NONE);
		}
		return result;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createNodeFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(5);
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	protected void setForegroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setForegroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setBackgroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setBackgroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineWidth(int width) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineWidth(width);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineType(int style) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineStyle(style);
		}
	}

	/**
	 * @generated
	 */
	public EditPart getPrimaryChildEditPart() {
		return getChildBySemanticHint(SammVisualIDRegistry.getType(WrappingLabelEditPart.VISUAL_ID));
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMARelTypesOnSource() {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		types.add(SammElementTypes.SubcomponentEndpoint_4001);
		types.add(SammElementTypes.ComponentEndpoint_4002);
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMARelTypesOnSourceAndTarget(
			IGraphicalEditPart targetEditPart) {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		if (targetEditPart instanceof InterfacePortEditPart) {
			types.add(SammElementTypes.SubcomponentEndpoint_4001);
		}
		if (targetEditPart instanceof InterfacePort2EditPart) {
			types.add(SammElementTypes.SubcomponentEndpoint_4001);
		}
		if (targetEditPart instanceof EventPortEditPart) {
			types.add(SammElementTypes.SubcomponentEndpoint_4001);
		}
		if (targetEditPart instanceof EventPort2EditPart) {
			types.add(SammElementTypes.SubcomponentEndpoint_4001);
		}
		if (targetEditPart instanceof InterfacePort3EditPart) {
			types.add(SammElementTypes.SubcomponentEndpoint_4001);
		}
		if (targetEditPart instanceof InterfacePort4EditPart) {
			types.add(SammElementTypes.SubcomponentEndpoint_4001);
		}
		if (targetEditPart instanceof EventPort3EditPart) {
			types.add(SammElementTypes.SubcomponentEndpoint_4001);
		}
		if (targetEditPart instanceof EventPort4EditPart) {
			types.add(SammElementTypes.SubcomponentEndpoint_4001);
		}
		if (targetEditPart instanceof InterfacePortEditPart) {
			types.add(SammElementTypes.ComponentEndpoint_4002);
		}
		if (targetEditPart instanceof InterfacePort2EditPart) {
			types.add(SammElementTypes.ComponentEndpoint_4002);
		}
		if (targetEditPart instanceof EventPortEditPart) {
			types.add(SammElementTypes.ComponentEndpoint_4002);
		}
		if (targetEditPart instanceof EventPort2EditPart) {
			types.add(SammElementTypes.ComponentEndpoint_4002);
		}
		if (targetEditPart instanceof InterfacePort3EditPart) {
			types.add(SammElementTypes.ComponentEndpoint_4002);
		}
		if (targetEditPart instanceof InterfacePort4EditPart) {
			types.add(SammElementTypes.ComponentEndpoint_4002);
		}
		if (targetEditPart instanceof EventPort3EditPart) {
			types.add(SammElementTypes.ComponentEndpoint_4002);
		}
		if (targetEditPart instanceof EventPort4EditPart) {
			types.add(SammElementTypes.ComponentEndpoint_4002);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMATypesForTarget(
			IElementType relationshipType) {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		if (relationshipType == SammElementTypes.SubcomponentEndpoint_4001) {
			types.add(SammElementTypes.InterfacePort_3011);
		}
		if (relationshipType == SammElementTypes.SubcomponentEndpoint_4001) {
			types.add(SammElementTypes.InterfacePort_3012);
		}
		if (relationshipType == SammElementTypes.SubcomponentEndpoint_4001) {
			types.add(SammElementTypes.EventPort_3013);
		}
		if (relationshipType == SammElementTypes.SubcomponentEndpoint_4001) {
			types.add(SammElementTypes.EventPort_3014);
		}
		if (relationshipType == SammElementTypes.SubcomponentEndpoint_4001) {
			types.add(SammElementTypes.InterfacePort_3015);
		}
		if (relationshipType == SammElementTypes.SubcomponentEndpoint_4001) {
			types.add(SammElementTypes.InterfacePort_3016);
		}
		if (relationshipType == SammElementTypes.SubcomponentEndpoint_4001) {
			types.add(SammElementTypes.EventPort_3019);
		}
		if (relationshipType == SammElementTypes.SubcomponentEndpoint_4001) {
			types.add(SammElementTypes.EventPort_3018);
		}
		if (relationshipType == SammElementTypes.ComponentEndpoint_4002) {
			types.add(SammElementTypes.InterfacePort_3011);
		}
		if (relationshipType == SammElementTypes.ComponentEndpoint_4002) {
			types.add(SammElementTypes.InterfacePort_3012);
		}
		if (relationshipType == SammElementTypes.ComponentEndpoint_4002) {
			types.add(SammElementTypes.EventPort_3013);
		}
		if (relationshipType == SammElementTypes.ComponentEndpoint_4002) {
			types.add(SammElementTypes.EventPort_3014);
		}
		if (relationshipType == SammElementTypes.ComponentEndpoint_4002) {
			types.add(SammElementTypes.InterfacePort_3015);
		}
		if (relationshipType == SammElementTypes.ComponentEndpoint_4002) {
			types.add(SammElementTypes.InterfacePort_3016);
		}
		if (relationshipType == SammElementTypes.ComponentEndpoint_4002) {
			types.add(SammElementTypes.EventPort_3019);
		}
		if (relationshipType == SammElementTypes.ComponentEndpoint_4002) {
			types.add(SammElementTypes.EventPort_3018);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public class ConnectorFigure extends Ellipse {

		/**
		 * @generated
		 */
		private WrappingLabel fFigureConnectorIconLabelFigure;

		/**
		 * @generated
		 */
		public ConnectorFigure() {

			GridLayout layoutThis = new GridLayout();
			layoutThis.numColumns = 1;
			layoutThis.makeColumnsEqualWidth = true;
			this.setLayoutManager(layoutThis);

			this.setLineWidth(1);
			this.setPreferredSize(new Dimension(getMapMode().DPtoLP(17), getMapMode().DPtoLP(17)));
			this.setMaximumSize(new Dimension(getMapMode().DPtoLP(20), getMapMode().DPtoLP(20)));
			createContents();
		}

		/**
		 * @generated
		 */
		private void createContents() {

			fFigureConnectorIconLabelFigure = new WrappingLabel();
			fFigureConnectorIconLabelFigure.setText("");

			GridData constraintFFigureConnectorIconLabelFigure = new GridData();
			constraintFFigureConnectorIconLabelFigure.verticalAlignment = GridData.CENTER;
			constraintFFigureConnectorIconLabelFigure.horizontalAlignment = GridData.CENTER;
			constraintFFigureConnectorIconLabelFigure.horizontalIndent = 0;
			constraintFFigureConnectorIconLabelFigure.horizontalSpan = 1;
			constraintFFigureConnectorIconLabelFigure.verticalSpan = 1;
			constraintFFigureConnectorIconLabelFigure.grabExcessHorizontalSpace = true;
			constraintFFigureConnectorIconLabelFigure.grabExcessVerticalSpace = true;
			this.add(fFigureConnectorIconLabelFigure, constraintFFigureConnectorIconLabelFigure);

		}

		/**
		 * @generated
		 */
		private boolean myUseLocalCoordinates = false;

		/**
		 * @generated
		 */
		protected boolean useLocalCoordinates() {
			return myUseLocalCoordinates;
		}

		/**
		 * @generated
		 */
		protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
			myUseLocalCoordinates = useLocalCoordinates;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureConnectorIconLabelFigure() {
			return fFigureConnectorIconLabelFigure;
		}

	}

}
