package eu.qimpress.ide.editors.gmf.composite.diagram.custom.providers;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import eu.qimpress.ide.editors.gmf.composite.diagram.custom.part.CustomSammDiagramEditorPlugin;
import eu.qimpress.samm.deployment.allocation.AllocationPackage;
import eu.qimpress.samm.deployment.allocation.Service;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

public class SammServiceDecorator extends AbstractDecorator implements IDecorator {

	private final class ServiceListener extends ResourceSetListenerImpl {
		@Override
		public void resourceSetChanged(ResourceSetChangeEvent event) {
			for (Notification msg : event.getNotifications()) {
				if (AllocationPackage.Literals.SERVICE__CONTAINER == msg.getFeature()) {
					Service service = (Service) msg.getNotifier();
					if (service.getSubcomponentInstance() == subcompInstance) {
						refresh();
					}
				}
			}
		}
		
	}

	private static final Image DEPLOYED_ICON = AbstractUIPlugin.imageDescriptorFromPlugin(CustomSammDiagramEditorPlugin.ID, "icons/Allocation.gif").createImage();
	
	private SubcomponentInstance subcompInstance;
	private GraphicalEditPart editPart;

	private TransactionalEditingDomain editingDomain;
	private ServiceListener serviceListener;


	
	public SammServiceDecorator(IDecoratorTarget decoratorTarget) {
		super(decoratorTarget);
		subcompInstance = (SubcomponentInstance) decoratorTarget.getAdapter(SubcomponentInstance.class);
		editPart = (GraphicalEditPart) decoratorTarget.getAdapter(GraphicalEditPart.class);
	}

	@Override
	public void activate() {
		editingDomain = TransactionUtil.getEditingDomain(subcompInstance.eContainer());
		editingDomain.addResourceSetListener(serviceListener = new ServiceListener());
	}

	@Override
	public void refresh() {
		removeDecoration();
		
		ServiceArchitectureModel sam = (ServiceArchitectureModel) subcompInstance.eContainer();
		boolean serviceFound = false;
		for (Service service : sam.getService()) {
			if (service.getSubcomponentInstance() == subcompInstance &&
					service.getContainer() != null) {
				serviceFound = true;
				break;
			}
		}
		
		if (!serviceFound) {
			return;
		}
		
		IMapMode mm = MapModeUtil.getMapMode(((ShapeEditPart)editPart).getFigure());
		setDecoration(getDecoratorTarget().addShapeDecoration(
			DEPLOYED_ICON, IDecoratorTarget.Direction.SOUTH_EAST, mm.DPtoLP(-4), true));

	}
	
	@Override
	public void deactivate() {
		super.deactivate();
		editingDomain.removeResourceSetListener(serviceListener);
	}

}
