package eu.qimpress.ide.editors.gmf.composite.diagram.custom.part;

import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.CompositeStructureEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammDiagramEditorPlugin;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;

public class CustomSammDiagramEditorPlugin extends AbstractUIPlugin{
	
	public static final String ID = "eu.qimpress.ide.editors.gmf.composite.diagram.custom"; //$NON-NLS-1$
	
	private static CustomSammDiagramEditorPlugin instance;
	
	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
		// Workaround for https://bugs.eclipse.org/bugs/show_bug.cgi?id=292038
        ViewService.createDiagram(StaticstructureFactory.eINSTANCE.createServiceArchitectureModel(),
        		CompositeStructureEditPart.MODEL_ID,
			SammDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
		instance = this;
	}
	
	@Override
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		instance = null;
	}
	
	public static CustomSammDiagramEditorPlugin getInstance() {
		return instance;
	}

}
