package eu.qimpress.ide.editors.gmf.composite.diagram.custom.figures;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;


/**
 * Custom figure representing SourceEventPort: <]--
 * 
 * @author wsa
 *
 */
public class SourceEventFigure extends AbstractBorderFigure {

	/** default position as affixed child */
	private static final int DEFAULT_POSITION = PositionConstants.EAST;
	
	/**
	 * @param size width and hight of the figure in logical units (LP)
	 * @param posType position type of the figure
	 */
	public SourceEventFigure(int logicalSize, PositionType posType) {
		super(logicalSize, posType);
	}

	@Override
	protected void paintFigure(Graphics graphics) {
		super.paintFigure(graphics);

		// determine the side the border item is located relative to it's parent
		int side = (getBorderItemLocator() == null ? DEFAULT_POSITION : getBorderItemLocator().getCurrentSideOfParent());
		
		Rectangle rect = graphics.getClip(new Rectangle());
		PointList arrowPoly = null;

		// depending on the side draw a connection line from the center of the side of the bounding box touching the parent
		// to the center of the bounding box and then draw event arrow in the remaining half of the bounding box so that 
		// the it points away from the parent
		switch(side){
		case PositionConstants.EAST:
			graphics.drawLine(rect.getLeft().x,rect.getCenter().y,rect.getCenter().x,rect.getCenter().y);
			arrowPoly = new PointList(5);
			arrowPoly.addPoint(rect.getTop().x, 			 rect.getCenter().y-rect.height/4);
			arrowPoly.addPoint(rect.getTop().x+rect.width/4, rect.getCenter().y-rect.height/4);
			arrowPoly.addPoint(rect.getRight());
			arrowPoly.addPoint(rect.getTop().x+rect.width/4, rect.getCenter().y+rect.height/4);
			arrowPoly.addPoint(rect.getBottom().x,			 rect.getCenter().y+rect.height/4);
			graphics.drawPolygon(arrowPoly);
			break;
		case PositionConstants.WEST:
			graphics.drawLine(rect.getRight().x,rect.getCenter().y,rect.getCenter().x,rect.getCenter().y);
			arrowPoly = new PointList(5);
			arrowPoly.addPoint(rect.getTop().x, 			 rect.getCenter().y-rect.height/4);
			arrowPoly.addPoint(rect.getTop().x-rect.width/4, rect.getCenter().y-rect.height/4);
			arrowPoly.addPoint(rect.getLeft());
			arrowPoly.addPoint(rect.getTop().x-rect.width/4, rect.getCenter().y+rect.height/4);
			arrowPoly.addPoint(rect.getBottom().x,			 rect.getCenter().y+rect.height/4);
			graphics.drawPolygon(arrowPoly);
			break;
		case PositionConstants.NORTH:
			graphics.drawLine(rect.getCenter().x,rect.getBottom().y,rect.getCenter().x,rect.getCenter().y);
			arrowPoly = new PointList(5);
			arrowPoly.addPoint(rect.getCenter().x-rect.width/4,	rect.getCenter().y);
			arrowPoly.addPoint(rect.getCenter().x-rect.width/4, rect.getCenter().y-rect.height/4);
			arrowPoly.addPoint(rect.getCenter().x,				rect.getTop().y);
			arrowPoly.addPoint(rect.getCenter().x+rect.width/4, rect.getCenter().y-rect.height/4);
			arrowPoly.addPoint(rect.getCenter().x+rect.width/4,	rect.getCenter().y);
			graphics.drawPolygon(arrowPoly);
			break;
		case PositionConstants.SOUTH:
			graphics.drawLine(rect.getCenter().x,rect.getTop().y,rect.getCenter().x,rect.getCenter().y);
			arrowPoly = new PointList(5);
			arrowPoly.addPoint(rect.getCenter().x-rect.width/4,	rect.getCenter().y);
			arrowPoly.addPoint(rect.getCenter().x-rect.width/4, rect.getCenter().y+rect.height/4);
			arrowPoly.addPoint(rect.getCenter().x,				rect.getBottom().y);
			arrowPoly.addPoint(rect.getCenter().x+rect.width/4, rect.getCenter().y+rect.height/4);
			arrowPoly.addPoint(rect.getCenter().x+rect.width/4,	rect.getCenter().y);
			graphics.drawPolygon(arrowPoly);
			break;
		}
		

	}

	private Point getArrowTip() {
		int side = (getBorderItemLocator() == null ? DEFAULT_POSITION : getBorderItemLocator().getCurrentSideOfParent());
		
		Rectangle rect = getBounds();
		Point result = null;
		
		switch(side){
		case PositionConstants.EAST:
			result = rect.getRight();
			break;
		case PositionConstants.WEST:
			result = rect.getLeft();
			break;
		case PositionConstants.NORTH:
			result = rect.getTop();
			break;
		case PositionConstants.SOUTH:
			result = rect.getBottom();
			break;
		}
		return result;

	}
	
	/**
	 * Places the anchor point at the tip of the [> part of the figure
	 */
	private class ArrowAnchor extends AbstractConnectionAnchor {

		public ArrowAnchor(IFigure owner) {
			super(owner);
		}
		
		public Point getLocation(Point reference) {
			Point p = getArrowTip();
			getOwner().translateToAbsolute(p);
			return p;
		}
	}
	
	@Override
	protected ConnectionAnchor createAnchorExternal() {
		return new StemAnchor(this);
	}

	@Override
	protected ConnectionAnchor createAnchorInternal() {
		return new ArrowAnchor(this);
	}

}
