package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.policies;

import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.commands.CustomSubcomponentEndPointReorientCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.commands.CustomSubcomponentEndpointCreateCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentEndpointEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentInstanceEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies.InterfacePortItemSemanticEditPolicy;
import eu.qimpress.ide.editors.gmf.composite.diagram.providers.SammElementTypes;

/**
 * The custom edit policy additionally sets the 'subcomponent' property of the SubcomponentEndpoint
 * connecting to the InterfacePort.
 * 
 * @author Wladimir Safonov
 *
 */
public class CustomInterfacePortItemSematicEditPolicy extends
		InterfacePortItemSemanticEditPolicy {

	
	public CustomInterfacePortItemSematicEditPolicy() {
	}
	
	/**
	 * Here we need to pass the SubcomponentInstance to the new command to save it for use during command execution
	 */
	protected Command getCompleteCreateRelationshipCommand(
			CreateRelationshipRequest req) {
		if (SammElementTypes.SubcomponentEndpoint_4001 == req.getElementType() && 
				this.getHost().getParent() instanceof SubcomponentInstanceEditPart) {
			
			SubcomponentInstanceEditPart parent = (SubcomponentInstanceEditPart) this.getHost().getParent();
			return getGEFWrapper(new CustomSubcomponentEndpointCreateCommand(req, req.getSource(), req.getTarget(),
					parent.resolveSemanticElement()));
		}
		return super.getCompleteCreateRelationshipCommand(req);
	}

	/**
	 * Returns command to reorient EClass based link. New link target or source
	 * should be the domain model element associated with this node.
	 * 
	 * @generated
	 */
	protected Command getReorientRelationshipCommand(
			ReorientRelationshipRequest req) {
		switch (getVisualID(req)) {
		case SubcomponentEndpointEditPart.VISUAL_ID:
			
			if (this.getHost().getParent() instanceof SubcomponentInstanceEditPart) {
				
				SubcomponentInstanceEditPart parent = (SubcomponentInstanceEditPart) this.getHost().getParent();
				return getGEFWrapper(new CustomSubcomponentEndPointReorientCommand(req, parent.resolveSemanticElement()));
			}
		}
		return super.getReorientRelationshipCommand(req);
	}


}
