package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.policies;

import java.util.Collection;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;

import eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.commands.CustomSubcomponentEndpointCreateCommand;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePort2EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePortEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies.ConnectorItemSemanticEditPolicy;
import eu.qimpress.ide.editors.gmf.composite.diagram.providers.SammElementTypes;
import eu.qimpress.samm.staticstructure.Port;

/**
 * Allows to properly initialize subcomponent feature of the SubcomponentEndpoint 
 * if it is created by drawing connection from Port to Connector (see also QIMPRESS-283).
 *
 * 
 * @author Wladimir Safonov
 *
 */
public class CustomConnectorItemSemanticEditPolicy extends ConnectorItemSemanticEditPolicy {

	@Override
	protected Command getCompleteCreateRelationshipCommand(CreateRelationshipRequest req) {
		if (SammElementTypes.SubcomponentEndpoint_4001 == req.getElementType() && 
				req.getSource() instanceof Port) {
			Port targetInnerPort = (Port) req.getSource();
			
			// find EditPart of the port
			GraphicalEditPart targetEditPart = null;
			Collection<EditPart> allEditParts = getHost().getViewer().getEditPartRegistry().values();
			for (EditPart editPart : allEditParts) {
				// EditParts for inner ports
				if (editPart instanceof InterfacePortEditPart || editPart instanceof InterfacePort2EditPart) {
					GraphicalEditPart innerPortEditPart = (GraphicalEditPart) editPart;
					if (innerPortEditPart.resolveSemanticElement() == targetInnerPort) {
						targetEditPart = innerPortEditPart;
						break;
					}
				}
			}
			
			// retrieve SubcomponentInstance and pass it to the SubcomponentEndpoint creation command
			if (targetEditPart != null) {
				GraphicalEditPart subcomponentInstanceEditPart = (GraphicalEditPart) targetEditPart.getParent();
				return getGEFWrapper(new CustomSubcomponentEndpointCreateCommand(req, req.getTarget(), req.getSource(), 
						subcomponentInstanceEditPart.resolveSemanticElement()));
			}
		}
		return super.getCompleteCreateRelationshipCommand(req);
	}
}
