package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.policies;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies.CompositeStructureCanonicalEditPolicy;

/**
 * Custom CanonicalEditPolicy for the CompositeStructure. This EditPolicy
 * adds the CompositeStructure to the list of its own children, so it will
 * be displayed on the Canvas.
 * 
 * @author Johannes Tysiak
 */
public class CustomCompositeStructureCanonicalEditPolicy extends
		CompositeStructureCanonicalEditPolicy {

	/**
	 * This overridden method adds the canvas element to the list of its 
	 * semantic children, so it can be displayed as an element on the Canvas.
	 */
	@SuppressWarnings("unchecked")
	@Override
	protected List getSemanticChildrenList() {
		// super.getSemanticChildrenList(); // this would add all other CompositeStructures contained in the same Resource
		List result = new LinkedList();
		View viewObject = (View) getHost().getModel();
		EObject modelObject = viewObject.getElement();
		result.add(modelObject);
		return result;
	}
	
}
