package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.parts;

import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.requests.RequestConstants;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.common.diagram.custom.util.GMFUtils;
import eu.qimpress.ide.editors.gmf.composite.diagram.custom.contributions.OpenCompositeDiagramAction;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentInstanceNameEditPart;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

public class CustomSubcomponentInstanceNameEditPart extends SubcomponentInstanceNameEditPart {

	public CustomSubcomponentInstanceNameEditPart(View view) {
		super(view);
	}

	public void performRequest(Request request) {
		
		if (RequestConstants.REQ_OPEN==request.getType()) {
			
			SubcomponentInstance subcompInstance = (SubcomponentInstance) resolveSemanticElement();
			if ( subcompInstance.getRealizedBy() instanceof CompositeComponent == false)
				return;

			CompositeComponent parentComponent = (CompositeComponent) subcompInstance.getRealizedBy();
			GMFUtils.createAndOpenDiagram(parentComponent, new OpenCompositeDiagramAction(parentComponent));
		}
		else
			super.performRequest(request);
	}
}

