package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.parts;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentInstanceEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies.SubcomponentInstanceItemSemanticEditPolicy;

public class CustomSubcomponentInstanceEditPart extends SubcomponentInstanceEditPart {

	public CustomSubcomponentInstanceEditPart(View view) {
		super(view);
	}
	
	@Override
	protected void createDefaultEditPolicies() {
		super.createDefaultEditPolicies();
		// completely disable port creation for subcomponent instances (QIMPRESS-277)
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new SubcomponentInstanceItemSemanticEditPolicy() {
			@Override
			protected Command getCreateCommand(CreateElementRequest req) {
				return UnexecutableCommand.INSTANCE;
			}
		});
	}

}
