package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.parts;

import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.CompositeComponentEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.CompositeStructureEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.ConnectorEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPort2EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPort3EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPort4EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPortEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePort2EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePort3EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePort4EditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.InterfacePortEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SammEditPartFactory;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentInstanceEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentInstanceNameEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammVisualIDRegistry;

/**
 * Custom EditPartFactory for the SAMM GMF Composite Editor. 
 * 
 * @author Johannes Tysiak
 */
public class CustomSammEditPartFactory extends SammEditPartFactory {

	@Override
	public EditPart createEditPart(EditPart context, Object model) {
		if (model instanceof View) {
			View view = (View) model;
			switch (SammVisualIDRegistry.getVisualID(view)) {
			
				case CompositeStructureEditPart.VISUAL_ID:
					return new CustomCompositeStructureEditPart(view);
					
				case InterfacePortEditPart.VISUAL_ID:
					return new CustomInterfacePortEditPart(view, true);
					
				case InterfacePort2EditPart.VISUAL_ID:
					return new CustomInterfacePort2EditPart(view, true);
					
				case InterfacePort3EditPart.VISUAL_ID:
					return new CustomInterfacePortEditPart(view, false);
					
				case InterfacePort4EditPart.VISUAL_ID:
					return new CustomInterfacePort2EditPart(view, false);
					
				case EventPortEditPart.VISUAL_ID:
					return new CustomEventPortEditPart(view, true);
					
				case EventPort2EditPart.VISUAL_ID:
					return new CustomEventPort2EditPart(view, true);
					
				case EventPort3EditPart.VISUAL_ID:
					return new CustomEventPortEditPart(view, false);
					
				case EventPort4EditPart.VISUAL_ID:
					return new CustomEventPort2EditPart(view, false);
					
				case SubcomponentInstanceEditPart.VISUAL_ID:
					return new CustomSubcomponentInstanceEditPart(view);
					
				case CompositeComponentEditPart.VISUAL_ID:
					return new CustomCompositeComponentEditPart(view);
					
				case ConnectorEditPart.VISUAL_ID:
					return new CustomConnectorEditPart(view);
					
				case SubcomponentInstanceNameEditPart.VISUAL_ID:
					return new CustomSubcomponentInstanceNameEditPart(view);
			}
		}
		return super.createEditPart(context, model);
	}
	
}
