package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.parts;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.composite.diagram.custom.figures.SinkEventFigure;
import eu.qimpress.ide.editors.gmf.composite.diagram.custom.figures.AbstractBorderFigure.PositionType;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.EventPort2EditPart;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;

/**
 * @author wsa
 *
 */
public class CustomEventPort2EditPart extends EventPort2EditPart {

	/**
	 * size of the figure in LP
	 */
	private static final int FIGURE_LOGICAL_SIZE = 30;
	
	private boolean internalPort;

	public CustomEventPort2EditPart(View view, boolean internalPort) {
		super(view);
		this.internalPort = internalPort;
	}
	
	@Override
	protected NodeFigure createMainFigure() {
		SinkEventFigure figure = new SinkEventFigure(
				getMapMode().DPtoLP(internalPort ? FIGURE_LOGICAL_SIZE : FIGURE_LOGICAL_SIZE*2),
				internalPort ? PositionType.POS_INTERNAL : PositionType.POS_EXTERNAL);
		figure.getBounds().setSize(figure.getPreferredSize());
		return figure;
	}
	
	@Override
	protected void createDefaultEditPolicies() {
		super.createDefaultEditPolicies();
		// enable deletion of outer ports on the ServiceArchitectureModel using keyboard (QIMPRESS-277)
		EObject semanticContainer = resolveSemanticElement().eContainer();
		if (!(semanticContainer instanceof ServiceArchitectureModel)) {
			installEditPolicy(EditPolicy.COMPONENT_ROLE, new ComponentEditPolicy() {
				@Override
				protected Command getDeleteCommand(GroupRequest request) {
					return UnexecutableCommand.INSTANCE;
				}
			});	
		}
	}

}
