package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.parts;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.View;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.CompositeComponentEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.policies.CompositeComponentItemSemanticEditPolicy;

public class CustomCompositeComponentEditPart extends CompositeComponentEditPart {

	public CustomCompositeComponentEditPart(View view) {
		super(view);
	}
	
	@Override
	protected void createDefaultEditPolicies() {
		super.createDefaultEditPolicies();
		// disable port creation for CompositeComponents (QIMPRESS-277)
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new CompositeComponentItemSemanticEditPolicy() {
			@Override
			protected Command getCreateCommand(CreateElementRequest req) {
				return UnexecutableCommand.INSTANCE;
			}
		});
	}

}
