package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.helpers.advices;

import java.util.ArrayList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.ui.PlatformUI;

import eu.qimpress.ide.editors.dialogs.selection.SammEObjectSelectionDialog;
import eu.qimpress.ide.editors.gmf.common.diagram.custom.edit.helpers.advices.EditHelperAdviceConstants;
import eu.qimpress.ide.ui.dialogs.selection.SelectEObjectDialog;
import eu.qimpress.samm.deployment.allocation.AllocationFactory;
import eu.qimpress.samm.deployment.allocation.Service;
import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.deployment.targetenvironment.Node;
import eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

public class ServiceArchitectureModelSubcomponentInstanceConfigurator extends
		AbstractEditHelperAdvice {

	@Override
	protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
		
		final SubcomponentInstance subcompInstance = (SubcomponentInstance) request.getElementToConfigure();
		
		if (!StaticstructurePackage.Literals.SERVICE_ARCHITECTURE_MODEL.isInstance(
				subcompInstance.eContainer())) {
			return null;
		}
		// ignore this advice if a previous advice canceled the request processing
		if (request.getParameter(EditHelperAdviceConstants.COMMAND_CANCELED_PARAM) == Boolean.TRUE) {
			return null;
		}
		
		ArrayList<Object> filterList = new ArrayList<Object>();
		filterList.add(TargetEnvironment.class);
		filterList.add(Node.class);
		filterList.add(Container.class);
//		ArrayList<EReference> additionalReferences = new ArrayList<EReference>();
//		additionalReferences.add(StaticstructurePackage.eINSTANCE.getInterfacePort_InterfaceType());
		SelectEObjectDialog dialog = new SammEObjectSelectionDialog(
				PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
				filterList, 
//				additionalReferences,
//				excludedContainments,
				request.getElementToConfigure().eResource().getResourceSet());
		dialog.setProvidedService(Container.class);
		dialog.open();

		if (dialog.getResult() == null || !(dialog.getResult() instanceof Container)) {
			return null;
		}
		
		final Container container = (Container) dialog.getResult();
		
		TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain(subcompInstance);
		RecordingCommand serviceCmd = new RecordingCommand(editingDomain, "Create Service") {
			
			@Override
			protected void doExecute() {
				Service service = AllocationFactory.eINSTANCE.createService();
				service.setName("Service_" + subcompInstance.getRealizedBy().getName() + "_" + container.getName());
				service.setSubcomponentInstance(subcompInstance);
				service.setContainer(container);
				((ServiceArchitectureModel) subcompInstance.eContainer()).getService().add(service);
			}
		};

		// composite command wrapping the actual model modification command
		ICompositeCommand compCmd = new CompositeCommand("ServiceArchitectureModelSubcomponentInstanceConfigurator");
		compCmd.add(new EMFCommandOperation(editingDomain, serviceCmd));

		return compCmd;
	}
	
	@Override
	protected ICommand getBeforeDestroyElementCommand(DestroyElementRequest request) {
		SubcomponentInstance subcompInstance = (SubcomponentInstance) request.getElementToDestroy();

		if (!StaticstructurePackage.Literals.SERVICE_ARCHITECTURE_MODEL.isInstance(
				subcompInstance.eContainer())) {
			return null;
		}
		
		final Service existingService = findExistingService(subcompInstance);
		DestroyElementCommand destroyCmd = null;
		if (existingService != null) {
			destroyCmd = new DestroyElementCommand(
					new DestroyElementRequest(existingService, false));
		}
		
		return destroyCmd;
	}
	
	private Service findExistingService(SubcomponentInstance subcomponentInstance) {
		ServiceArchitectureModel sam = (ServiceArchitectureModel) subcomponentInstance.eContainer();
		for (Service service : sam.getService()) {
			if (service.getSubcomponentInstance() == subcomponentInstance) {
				return service;
			}
		}
		return null;
	}
	
}
