package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;

import eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.SubcomponentEndpointCreateCommand;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

/*
 * The new command saves information available at a certain point in the editor command chain
	 * for use in a later step in this chain. The original command did not contain this information any
	 * more when it was needed.
 */
public class CustomSubcomponentEndpointCreateCommand extends SubcomponentEndpointCreateCommand {
	/*
	 * subcomponent saves information available at a certain point in the editor command chain
	 * for use in a later step in this chain.
	 */
	private final EObject subcomponent;

	public CustomSubcomponentEndpointCreateCommand(CreateRelationshipRequest request,
			EObject source, EObject target, EObject subcomponent) {
		super(request, source, target);
		/*
		 * save the information about the SubcomponentInstance to whose Port the connection shall be made.
		 * This information is used while executing the command.
		 */
		this.subcomponent = subcomponent;
	}

	protected CommandResult doExecuteWithResult(IProgressMonitor monitor,
			IAdaptable info) throws ExecutionException {
		if (!canExecute()) {
			throw new ExecutionException(
					"Invalid arguments in create link command"); //$NON-NLS-1$
		}
		CommandResult result = super.doExecuteWithResult(monitor, info);
		SubcomponentEndpoint newElement =(SubcomponentEndpoint) result.getReturnValue();
		/*
		 * Set the reference to the subcomponentInstance in the SubcomponentEndPoint
		 */
		newElement.setSubcomponent((SubcomponentInstance)subcomponent);
		return CommandResult.newOKCommandResult(newElement);

	}

}
