package eu.qimpress.ide.editors.gmf.composite.diagram.custom.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.SubcomponentEndpointReorientCommand;


/**
 * The custom command saves the subcomponent instance reference of the new end of the SubcomponentEndPoint
 * for use in the command execution method.
 * This is necessary as the model contains that reference and it cannot be filled by 'normal' editor operations.
 * 
 * @author Michael Riedmueller
 *
 */
public class CustomSubcomponentEndPointReorientCommand extends
		SubcomponentEndpointReorientCommand {
/**
 * newSubcomponent saves the reference to the target SubcomponentInstance of the SubcomponentEndPoint
 * This information would otherwise not be accessible, as the Port is not instantiated.
 */
	private final EObject newSubcomponent;
	
/**
 * endPoint saves the reference to the SubcomponentEndPoint whose property 'subcomponent'
 * needs to be changed to the SubcomponentInstance containing the new Port.
 * It reference is accessible in newSubcomponent.
 */
	private final EObject endPoint;
	
	public CustomSubcomponentEndPointReorientCommand(
			ReorientRelationshipRequest request, EObject subcomponent) {
		super(request);
		/*
		 * save the information that is available at this point for later use in the method executing the command.
		 */
		this.newSubcomponent = subcomponent;
		this.endPoint = request.getRelationship();
	}
	/*
	 * (non-Javadoc)
	 * @see eu.qimpress.ide.editors.gmf.composite.diagram.edit.commands.SubcomponentEndpointReorientCommand#doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor, org.eclipse.core.runtime.IAdaptable)
	 * use the information saved in the new command to set properties in the model elements
	 * in our case when reorienting connections, the references need to be changed as well
	 */
@Override
protected CommandResult doExecuteWithResult(IProgressMonitor monitor,
		IAdaptable info) throws ExecutionException {
	CommandResult result = super.doExecuteWithResult(monitor, info);
	((SubcomponentEndpoint)endPoint).setSubcomponent((SubcomponentInstance)this.newSubcomponent);
	return result;
}
}
