package eu.qimpress.ide.editors.gmf.composite.diagram.custom.contributions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Diagram;

import eu.qimpress.ide.editors.gmf.common.diagram.custom.contributions.AbstractOpenDiagramAction;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.CompositeStructureEditPart;
import eu.qimpress.ide.editors.gmf.composite.diagram.part.SammDiagramEditorPlugin;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;


public class OpenCompositeDiagramAction extends AbstractOpenDiagramAction {

	public OpenCompositeDiagramAction() {
	}
	
	public OpenCompositeDiagramAction(CompositeStructure diagramRoot) {
		this.diagramRoot = diagramRoot;
	}
	
	@Override
	public Diagram createDiagramView(EObject root) {
		return ViewService.createDiagram( root,
				CompositeStructureEditPart.MODEL_ID,
				SammDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
	}

	@Override
	public String getFileExtension() {
		return "samm_servicearchitecturemodel_diagram";
	}

	@Override
	protected EObject getDiagramRoot(Object selectedElement) {
		EObject diagramRoot = super.getDiagramRoot(selectedElement);
		if (diagramRoot instanceof SubcomponentInstance) {
			return ((SubcomponentInstance) diagramRoot).getRealizedBy();
		}
		return diagramRoot;
	}


}
