package eu.qimpress.ide.editors.gmf.composite.diagram.custom.contributions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.IPopupMenuContributionPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;

/**
 * Context menu contribution policy which allows to disable delete actions 
 * for all ports except outer ports of the ServiceArchitectureModel element (QIMPRESS-277).
 * 
 * @author wsa
 *
 */
public class InternalPortsDeleteActionsContributionPolicy implements IPopupMenuContributionPolicy {

	@Override
	public boolean appliesTo(ISelection selection, IConfigurationElement configuration) {
		Object firstElement = ((IStructuredSelection) selection).getFirstElement();
		if (firstElement != null && firstElement instanceof GraphicalEditPart) {
			GraphicalEditPart selectedEditPart = (GraphicalEditPart) firstElement;
			EObject semanticContainer = selectedEditPart.resolveSemanticElement().eContainer();
			return !(semanticContainer instanceof ServiceArchitectureModel);
		}
		return false;
	}

}
