package eu.qimpress.ide.editors.gmf.composite.diagram.custom.contributions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.services.action.filter.AbstractActionFilterProvider;
import org.eclipse.gmf.runtime.common.ui.services.action.filter.TestAttributeOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;

/**
 * Used to enable ConfigureDeploymentAction only for SubcomponentInstances inside 
 * of a ServiceArchitectureModel (by checking its eContainer class).
 * 
 * @author wsa
 *
 */
public class ConfigureDeploymentActionFilterProvider extends AbstractActionFilterProvider {

	private static final String SEMANTIC_ECONTAINER_PROPERTY = "eu.qimpress.ide.editors.gmf.composite.diagram.custom.semanticEContainerFilterProperty";
	
	public ConfigureDeploymentActionFilterProvider() {
	}

	@Override
	public boolean testAttribute(Object target, String name, String value) {
		if (target instanceof GraphicalEditPart) {
			EObject eObject = ((GraphicalEditPart) target).resolveSemanticElement();
			if (SEMANTIC_ECONTAINER_PROPERTY.equals(name)) {
				return eObject.eContainer() != null && eObject.eContainer().getClass().getName().equals(value);
			}
		}
		return false;
	}

	@Override
	public boolean provides(IOperation operation) {
		if (operation instanceof TestAttributeOperation) {
			TestAttributeOperation op = (TestAttributeOperation) operation;
			return SEMANTIC_ECONTAINER_PROPERTY.equals(op.getName());
		}
		return false;
	}

}
