package eu.qimpress.ide.editors.gmf.composite.diagram.custom.contributions;

import java.util.ArrayList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

import eu.qimpress.ide.editors.dialogs.selection.SammEObjectSelectionDialog;
import eu.qimpress.ide.editors.gmf.composite.diagram.edit.parts.SubcomponentInstanceEditPart;
import eu.qimpress.ide.ui.dialogs.selection.SelectEObjectDialog;
import eu.qimpress.samm.deployment.allocation.AllocationFactory;
import eu.qimpress.samm.deployment.allocation.Service;
import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.deployment.targetenvironment.Node;
import eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

public class ConfigureDeploymentAction implements IObjectActionDelegate {

	private SubcomponentInstanceEditPart editPart;
	private SubcomponentInstance subcomponentInstance;

	@Override
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {

	}

	@Override
	public void run(IAction action) {
		if (subcomponentInstance == null) {
			return;
		}
		
		final Service existingService = findExistingService(subcomponentInstance);
		
		ArrayList<Object> filterList = new ArrayList<Object>();
		filterList.add(TargetEnvironment.class);
		filterList.add(Node.class);
		filterList.add(Container.class);
//		ArrayList<EReference> additionalReferences = new ArrayList<EReference>();
//		additionalReferences.add(StaticstructurePackage.eINSTANCE.getInterfacePort_InterfaceType());
		SelectEObjectDialog dialog = new SammEObjectSelectionDialog(
				PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
				filterList, 
//				additionalReferences,
//				excludedContainments,
				subcomponentInstance.eResource().getResourceSet());
		dialog.setProvidedService(Container.class);
		if (existingService != null && existingService.getContainer() != null) {
			dialog.setInitialSelection(existingService.getContainer());
		}
		dialog.open();
		

		if (dialog.getResult() == null || !(dialog.getResult() instanceof Container)) {
			return;
		}
		
		final Container container = (Container) dialog.getResult();
		TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain(subcomponentInstance);
		RecordingCommand cmd = new RecordingCommand(editingDomain, "Set Container") {
			
			@Override
			protected void doExecute() {
				Service service = existingService;
				if (service == null) {
					service = AllocationFactory.eINSTANCE.createService();
					service.setSubcomponentInstance(subcomponentInstance);
					((ServiceArchitectureModel) subcomponentInstance.eContainer()).getService().add(service);
				}
				service.setContainer(container);
			}
		};
		editingDomain.getCommandStack().execute(cmd);
		
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		editPart = (SubcomponentInstanceEditPart) ((IStructuredSelection) selection).getFirstElement();
		if (editPart != null) {
			
			subcomponentInstance = (SubcomponentInstance) editPart.resolveSemanticElement();
		}
	}
	
	private Service findExistingService(SubcomponentInstance subcomponentInstance) {
		ServiceArchitectureModel sam = (ServiceArchitectureModel) subcomponentInstance.eContainer();
		for (Service service : sam.getService()) {
			if (service.getSubcomponentInstance() == subcomponentInstance) {
				return service;
			}
		}
		return null;
	}
	
}
