package eu.qimpress.ide.editors.gmf.common.diagram.custom.util;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

import eu.qimpress.ide.backbone.core.model.IQModel;

/**
 * This utility class enables the modification of ISelection objects containing objects
 * from the Q-ImPrESS model (as specified in <link>eu.qimpress.ide.backbone.core.model.*</link>.
 * Such objects within the ISelection can be transformed to their corresponding Eclipse
 * objects (such as IResource or IFile). 
 * 
 * @author Johannes Tysiak
 */
public class SelectionConverter {

	/**
	 * This method converts IQModel objects within an ISelection to their corresponding
	 * IFile objects. Objects within the ISelection which are not IQModel will not be modified.
	 * 
	 * @param oldSelection the original ISelection containing IQModel objects
	 * @return the modified ISelection
	 */
	public static ISelection convertSelectionIQModelToIFile (ISelection oldSelection) {
		if (oldSelection instanceof IStructuredSelection == true
				&& !oldSelection.isEmpty()) {
			List<Object> oldSelectionList = ((IStructuredSelection) oldSelection).toList();
			List<Object> newSelectionList = new LinkedList<Object>();			
			for (Object currentItem : oldSelectionList) {
				if (currentItem instanceof IQModel) {
					IResource modelResource = ((IQModel) currentItem).getCorrespondingResource();
					if (modelResource instanceof IFile) {
						IFile modelFile = (IFile) modelResource;
						newSelectionList.add(modelFile);
					}
					else {
						newSelectionList.add(currentItem);
					}
				}
				else {
					newSelectionList.add(currentItem);
				}
			}
			return new StructuredSelection(newSelectionList);
		}
		else {
			return oldSelection;
		}
	}
	
}
