package eu.qimpress.ide.editors.gmf.common.diagram.custom.util;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import eu.qimpress.ide.editors.gmf.common.diagram.custom.contributions.AbstractOpenDiagramAction;

public class GMFUtils {
	
	private static Logger log = LogFactory.getLog(GMFUtils.class);
	
	public static void createAndOpenDiagram(EObject diagramRoot, AbstractOpenDiagramAction action){
		TransactionalEditingDomain eDomain = DiagramEditingDomainFactory.getInstance().createEditingDomain();
		URI diagramRootUri = diagramRoot.eResource().getURI();
		URI uri = diagramRootUri.trimSegments(1).appendSegment("diagrams")
	    	.appendSegment(action.getID()).appendFileExtension(action.getFileExtension());
		Resource diagramResource = null;
		try{
			diagramResource = eDomain.getResourceSet().getResource(uri, true);
			if(diagramResource.getContents().size() == 0)
				diagramResource = null;
		}catch (Throwable e) {
			diagramResource = null;
		}
		if(diagramResource == null){
			diagramResource = eDomain.getResourceSet().createResource(uri);
			createDiagram(eDomain, diagramResource, diagramRoot, action);
			try{
				diagramResource.save(getSaveOptions());
			} catch (IOException e) {
				log.error("error while saving diagram", e);
			} 
		}
		String name = null;
		try{
			name = (String) diagramRoot.eGet(diagramRoot.eClass().getEStructuralFeature("name"));
		} catch (Exception e) {
			// doesn't have a name feature
		}
		openDiagram(diagramResource.getURI(), name);
	}
	
	public static void createDiagram(	TransactionalEditingDomain eDomain,
								final Resource diagramResource, 
								EObject root,
								AbstractOpenDiagramAction action) 
	{
		final Diagram diagram = action.createDiagramView(root);
		
		AbstractTransactionalCommand command = new AbstractTransactionalCommand(eDomain,
				"Adding diagram to resource", Collections.EMPTY_LIST) {
			protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info)
					throws ExecutionException {
				diagramResource.getContents().add(diagram);
				return CommandResult.newOKCommandResult();
			}
		};
		try {
			OperationHistoryFactory.getOperationHistory().execute(command, null, null);
		} catch (ExecutionException e) {
			log.error("error while adding diagram to resource", e);
		}
		
	}
	
	public static void openDiagram(URI uri, String name) {
		URIEditorInput input = null;
		if(name != null)
			input = new URIEditorInput( uri, name );
		else
			input = new URIEditorInput( uri );
		String editorID = PlatformUI.getWorkbench().getEditorRegistry()
	      .getDefaultEditor("*."+uri.fileExtension()).getId();
		try {
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()
			.openEditor(input, editorID);
		} catch (PartInitException e) {
			log.error("error while opening diagram", e);
		}
	}
	
	public static Map getSaveOptions() {
		Map saveOptions = new HashMap();
		saveOptions.put(XMLResource.OPTION_ENCODING, "UTF-8"); //$NON-NLS-1$
		saveOptions.put(Resource.OPTION_SAVE_ONLY_IF_CHANGED,
				Resource.OPTION_SAVE_ONLY_IF_CHANGED_MEMORY_BUFFER);
		return saveOptions;
	}

	public static void saveActiveEditor() {
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()
		 .getActiveEditor().doSave(new NullProgressMonitor ());
	}


}
