package eu.qimpress.ide.editors.gmf.common.diagram.custom.util;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;



public class FileUtil {

	private static Logger log = LogFactory.getLog(FileUtil.class);
	
	public static URI getURI(IFile file) {
		return URI.createPlatformResourceURI(file.getFullPath().toString(),
				true);
	}

	public static IFile getIFile(URI uri) {
		return ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(uri.toPlatformString(true)));
	}
	
	public static List<IFile> getFile(IContainer folder, String extension) {
		try {
			List<IFile> files = new ArrayList<IFile>();
			for (IResource res : folder.members()) {
				if( false == res instanceof IFile)
					continue;
				IFile file = (IFile) res;
				if(extension.equals(file.getFileExtension()))
						files.add(file);
			}
			return files;
		} catch (Throwable e) {
			log.error("error while accessing members of '"+ folder.getLocation().toString() +"'", e);
		}
		return null;
	}

	public static final List<EObject> getContents(String resourceURI,
			EObject context) {
		ResourceSet resourceSet;
		try {
			resourceSet = context.eResource().getResourceSet();
		} catch (Exception exc) {
			resourceSet = new ResourceSetImpl();
		}
		Resource resource = resourceSet.getResource(URI.createURI(resourceURI),
				true);
		return resource.getContents();
	}
		
}