package eu.qimpress.ide.editors.gmf.common.diagram.custom.edit.helpers.advices;

import java.util.ArrayList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.ui.PlatformUI;

import eu.qimpress.ide.editors.dialogs.selection.SammEObjectSelectionDialog;
import eu.qimpress.ide.editors.gmf.common.diagram.custom.commands.CanceledCommand;
import eu.qimpress.ide.ui.dialogs.selection.SelectEObjectDialog;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

/**
 * Adds configuration possibility for a newly created {@link SubcomponentInstance}
 * allowing to select {@link ComponentType} for the {@link SubcomponentInstance#getRealizedBy() realizedBy} 
 * feature in a pop-up dialog. Selection list is filtered to {@link ComponentType}s
 * from any {@link Repository}s loaded in the same ResourceSet as the edited {@link CompositeStructure}.
 * 
 * @author mri
 *
 */
public class SubcomponentInstanceEditHelperAdvice extends
		AbstractEditHelperAdvice {

	@Override
	protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
		EObject componentType = null;
		ArrayList<Object> filterList = new ArrayList<Object>();
		filterList.add(Repository.class);
		filterList.add(ComponentType.class);
		SelectEObjectDialog dialog = new SammEObjectSelectionDialog(
				PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
				filterList, 
				request.getElementToConfigure().eResource().getResourceSet());
		dialog.setProvidedService(ComponentType.class);
		dialog.open();

		if (dialog.getResult() == null || !(dialog.getResult() instanceof ComponentType)) {
			request.setParameter(EditHelperAdviceConstants.COMMAND_CANCELED_PARAM, Boolean.TRUE);
			return new CanceledCommand();
		}
		
		componentType = (ComponentType) dialog.getResult();
		ICommand cmd = new SetValueCommand(
				new SetRequest(
						request.getElementToConfigure(), 
						StaticstructurePackage.eINSTANCE.getSubcomponentInstance_RealizedBy(),
						componentType));
		return cmd;
	}
}
