package eu.qimpress.ide.editors.gmf.common.diagram.custom.contributions;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import eu.qimpress.ide.editors.gmf.common.diagram.custom.util.GMFUtils;
import eu.qimpress.ide.editors.gmf.common.diagram.custom.util.LogFactory;
import eu.qimpress.samm.core.Entity;


public abstract class AbstractOpenDiagramAction implements IObjectActionDelegate {

	private Shell shell = null;
	protected EObject diagramRoot = null;
	private Logger log = LogFactory.getLog(AbstractOpenDiagramAction.class);

	public abstract String getFileExtension();

	public abstract Diagram createDiagramView(EObject root);

	
	@Override
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.shell = targetPart.getSite().getShell();	
	}

	@Override
	public void run(IAction action) {
		GMFUtils.createAndOpenDiagram(diagramRoot, this);
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection != null && selection instanceof IStructuredSelection) {
			IStructuredSelection sselection = (IStructuredSelection) selection;
			if (!sselection.isEmpty()) {
				diagramRoot = getDiagramRoot(sselection.getFirstElement());
			} 
		}
	}

	protected EObject getDiagramRoot(Object selectedElement) {
		if (selectedElement instanceof EObject) {
			return (EObject) selectedElement;				
		}
		else if (selectedElement instanceof GraphicalEditPart) {
			return ((GraphicalEditPart) selectedElement).resolveSemanticElement();
		}
		return null;
	}
	
	public String getID(){
		return this.getID(diagramRoot);
	}
	
	protected String getID(EObject diagramRoot){
		return ((Entity)diagramRoot).getId();
	}
	
	



}
