package eu.qimpress.ide.editors.form.qoseditor.wizards.widgets;

/**
 * 
 */

import java.util.ArrayList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.ui.models.adapters.QModelsComposedAdapterFactoryProvider;
import eu.qimpress.ide.editors.form.qoseditor.QoSEditorUtils;

/**
 * Tree viewer for selecting Projects.
 * 
 * The viewer allows selection of single of multiple Projects according to a
 * configuration.
 * 
 * @author Tomas Pop
 * 
 */

public class AnnotableEntitiesViewer extends CheckboxTreeViewer {
	
	public Object[] selectedEntities;
	public Object[] initialyAnnotatedEntities;
	int currentAnnotationIndex = -1;
	

	public AnnotableEntitiesViewer(Composite parent, int style, int numAnnotations) {
		
		super(parent, style);
		this.setContentProvider(new annotableTreeContentProvider());
		
		this.setInput(new entityViewerInfo(null, null));
		this.setLabelProvider(new AdapterFactoryLabelProvider(
				QModelsComposedAdapterFactoryProvider.getInstance().getAdapterFactory()));
		
		selectedEntities = new Object[numAnnotations];	
		for (int i = 0; i <numAnnotations; i++){
			selectedEntities[i] =  new ArrayList<EObject>();
		}
		
		initialyAnnotatedEntities = new Object[numAnnotations];	
		for (int i = 0; i <numAnnotations; i++){
			initialyAnnotatedEntities[i] =  new ArrayList<EObject>();
		}
		
		this.addSelectionChangedListener(new ISelectionChangedListener() {	
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				
			}
		});	
	}

	
	
	public void saveCurrentSelection(){
		
		/* don't care about initial selection */
		if (currentAnnotationIndex != -1){
			ArrayList<EObject> selectedEntitiesForAnnotationIndex = new ArrayList<EObject>();
			
			for (int i = 0; i < getCheckedElements().length; i++) {
				selectedEntitiesForAnnotationIndex.add((EObject) getCheckedElements()[i]);
			}
			selectedEntities[currentAnnotationIndex] = selectedEntitiesForAnnotationIndex;
		}
	}
	
	
	@SuppressWarnings({ "unchecked", "deprecation" })
	public void restorePreviousSelection(){
		
		
		this.refresh();
		this.setAllChecked(false);
		
		if (currentAnnotationIndex != -1){
			for (int i = 0; i < ((ArrayList<EObject>)selectedEntities[currentAnnotationIndex]).size(); i ++ ) {
				this.setChecked( ( (ArrayList<EObject>) selectedEntities[currentAnnotationIndex]).get(i)  , true);
			}
		}
	}
	
	public void selectedAnotationChanged(EClass annTypeA, IQProject projectA, int annIndex){
		
		if (currentAnnotationIndex != annIndex){
		
			this.saveCurrentSelection();
			this.currentAnnotationIndex = annIndex;
			
			this.setInput(new entityViewerInfo(annTypeA, projectA));
			
			this.restorePreviousSelection();
		}
	}
	
	public EObject getSelectedEObject(){
		ISelection selection = getSelection();
		if (selection instanceof IStructuredSelection
				&& !((IStructuredSelection) selection).isEmpty()) {
			Object o = ((IStructuredSelection) selection).getFirstElement();
			
			if (o instanceof EObject) {
				return (EObject) o;
			}
		}
		return null;
	}
}

class entityViewerInfo {
	public EClass annType;
	public IQProject project;
	public entityViewerInfo(EClass annTypeA, IQProject projectA){
		annType = annTypeA;
		project = projectA;
	}
}

class annotableTreeContentProvider implements ITreeContentProvider {
	  /**
	   * Gets the children of the specified object
	   */
	
	  public Object[] getChildren(Object arg0) { 
	    return new Object[] {};
	  }

	  /**
	   * Gets the parent of the specified object
	   */
	  public Object getParent(Object arg0) {
	    return null;
	  }

	  /**
	   * Returns whether the passed object has children
	   * @param arg0 the parent object
	   * @return boolean
	   */
	  public boolean hasChildren(Object arg0) {
	    return false;
	  }

	  /**
	   * Gets the root element(s) of the tree
	   * @param arg0 the input data
	   * @return Object[] - top level object in the tree
	   */
	  public Object[] getElements(Object arg0) {
		  Object[] ret;
		  if (((entityViewerInfo) arg0). project == null){
			  ret = new Object[0];
		  }else {
			  ret = QoSEditorUtils.getAnnotatableEntitiesByAnnotation(
					  ((entityViewerInfo) arg0).project, 
					  ((entityViewerInfo) arg0).annType
					);
		  }  
		  return ret;
	  }

	  public void dispose() {
	    /* Nothing to dispose */
	  }

	  public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
	    /* Nothing to change */
	  }
	}