/**
 * 
 */
package eu.qimpress.ide.editors.form.qoseditor.wizards.pages;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.ui.widgets.QProjectViewer;

/**
 * @author Tomas Pop
 *
 */
public class SelectProjectPage extends WizardPage {
	
	Text projectNameField;
	QProjectViewer projectViewer;
	IQProject initialProjectSelection = null;

	public SelectProjectPage(IQProject selectedProject) {
		super("Annotation Wizard - select project");
		
		setTitle("Annotation Wizard");
		setDescription("Select project, where annotatios should be changed");
		setPageComplete(false);
		initialProjectSelection = selectedProject;		
	}


	@Override
	public void createControl(Composite parent) {
		final Composite composite = new Composite(parent, SWT.NULL);
		
		initializeDialogUnits(parent);
		composite.setLayout(new GridLayout(1, false));
		setControl(composite);
		
		// Select project widget label
		Label parentAlternativeLabel = new Label(composite, SWT.NONE);
		parentAlternativeLabel.setText("Select Project");
		GridDataFactory.generate(parentAlternativeLabel, 1, 1);
		
		projectViewer = new QProjectViewer(composite, 
				SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.VIRTUAL,
				true);
		
		GridDataFactory.generate(projectViewer.getControl(), 3, 1);
		
		projectViewer.addCheckStateListener( new ICheckStateListener() {
			
			@Override
			public void checkStateChanged(CheckStateChangedEvent event) {
				boolean valid;
				valid = validatePage();
				SelectProjectPage.this.setPageComplete(valid);
			}
		});
		
		if (initialProjectSelection != null) {
			projectViewer.setSelection(new StructuredSelection(initialProjectSelection.getProject()), true);
			projectViewer.setChecked(initialProjectSelection.getProject(), true);
			this.setPageComplete(true);
		}
		
	}	
	
	public boolean validatePage() {
		boolean valid;
		if (projectViewer.getSelectedProjects().size() > 0){
			return true;
		}		
		valid = false;
		return valid;
	}
	
	/**
	 * Returns selected project
	 * @return selected project od null if the project was not selected yet
	 */
	public IQProject getSelectedProject(){
		if (projectViewer.getSelectedProjects().size() < 1) {
			return null;
		}
		return projectViewer.getSelectedProjects().get(0);
	}
	
}
