/**
 * 
 */
package eu.qimpress.ide.editors.form.qoseditor.wizards.pages;

import java.util.ArrayList;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.models.ShadowModelEditorUtils;
import eu.qimpress.ide.editors.form.qoseditor.QoSEditorUtils;
import eu.qimpress.ide.editors.form.qoseditor.properties.AssociatedQoSAnnotationSection;
import eu.qimpress.ide.editors.form.qoseditor.properties.EMFExtendedPropertySheetPage;
import eu.qimpress.ide.editors.form.qoseditor.wizards.QoSAnnotationWizard;
import eu.qimpress.ide.editors.form.qoseditor.wizards.widgets.AnnotableEntitiesViewer;
import eu.qimpress.samm.qosannotation.Annotation;

/**
 * @author Michal Malohlava
 *
 */
public class SelectAnnotationAndEntitiesPage extends WizardPage {
	
	private static final Logger logger = Logger.getLogger(AssociatedQoSAnnotationSection.class);
	
	Button showAllEntities; // switch between all entities view and only un-annotated entities	
	
	/** widget displaying annotation types */
	List annotationSelector;
	
	/** Annotable entities list */
	AnnotableEntitiesViewer entityViewer;
	
	/** Annotation editor */
	private EMFExtendedPropertySheetPage annotationEntityPrototypeEditor = null;
	
	/** Selected SAMM property viewer */
	private EMFExtendedPropertySheetPage annotatedObjectPropertyDisplayer = null;
	
	/** List of all defined annotation types */
	private EClass[] annotationTypes;
	/** Map of annotation prototypes */ 
	private Map<EClass, Annotation> annotationPrototypes;
	
	public SelectAnnotationAndEntitiesPage(IQProject selectedProject) {
		super("Annotation Wizard - select annotation and entity page");
		
		setTitle("Annotation Wizard");
		setDescription("Select project, where annotatios should be changed");
		setPageComplete(false);
	}

	@Override
	public void createControl(Composite parent) {
		final Composite composite = new Composite(parent, SWT.NULL);
		
		initializeDialogUnits(parent);
		composite.setLayout(new GridLayout(2, true));
		
		setControl(composite);
		
		Label annotationSelectorLabel = new Label(composite, SWT.NONE);
		annotationSelectorLabel.setText("Select Annotation Type");
		GridDataFactory.generate(annotationSelectorLabel, 1, 1);
		
		Label entityList = new Label(composite, SWT.NONE);
		entityList.setText("Select Entities");
		GridDataFactory.generate(entityList, 1, 1);
		
		annotationSelector = createAnnotationTypeList(composite);
		annotationTypes = ((QoSAnnotationWizard)getWizard()).annotationTypes;
		annotationPrototypes = QoSEditorUtils.createPrototypeInstances(annotationTypes);
		
		annotationSelector.removeAll();
		
		for (EClass annotation : annotationTypes) {
			String key = annotation.getName();
			annotationSelector.add(key);			
		}
		
		entityViewer = new AnnotableEntitiesViewer(composite, 
				SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.VIRTUAL, 
				annotationTypes.length);
		
		
		GridDataFactory.generate(annotationSelector, 1, 1);
		GridDataFactory.generate(entityViewer.getControl(), 1, 1);
		
		showAllEntities = new Button(composite, SWT.CHECK);
		showAllEntities.setText("Show all");
		showAllEntities.setSelection(true);		
		GridDataFactory.defaultsFor(showAllEntities).span(2, 1).align(SWT.END, SWT.CENTER).applyTo(showAllEntities);

		Label annotationEntityPrototypeLabel = new Label(composite, SWT.NONE);
		annotationEntityPrototypeLabel.setText("Annotation prototype");
		GridDataFactory.generate(annotationEntityPrototypeLabel, 1, 1);
		
		Label entityDisplayerLabel = new Label(composite, SWT.NONE);
		entityDisplayerLabel.setText("Selected entity");
		GridDataFactory.generate(entityDisplayerLabel, 1, 1);
		
		annotationEntityPrototypeEditor = new EMFExtendedPropertySheetPage();
		annotationEntityPrototypeEditor.createControl(composite);
		GridDataFactory.generate(annotationEntityPrototypeEditor.getControl(), 1, 1);
		
		annotatedObjectPropertyDisplayer = new EMFExtendedPropertySheetPage();
		annotatedObjectPropertyDisplayer.createControl(composite);
		GridDataFactory.generate(annotatedObjectPropertyDisplayer.getControl(), 1, 1);
		
		annotationSelector.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				int index = 0;
				if ((index = annotationSelector.getSelectionIndex()) != -1) {
					EClass eClass = annotationTypes[index];
					Annotation annotation = annotationPrototypes.get(eClass);
					annotationEntityPrototypeEditor.selectionChanged(null, new StructuredSelection(annotation));
					
					try {
						annotationEntityPrototypeEditor.setEditingDomain((AdapterFactoryEditingDomain) ShadowModelEditorUtils.getDefaultEditingDomain(((SelectProjectPage) SelectAnnotationAndEntitiesPage.this.getPreviousPage()).getSelectedProject().getProject()));
					} catch (RepositoryException e1) {
						e1.printStackTrace();
					}
				}
				
			}			
		});
		
		entityViewer.addSelectionChangedListener(new ISelectionChangedListener() {			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {				
				annotatedObjectPropertyDisplayer.selectionChanged(null, event.getSelection());
				
				
				validatePage();
			}
		});
		
	}	
	
	
	@SuppressWarnings("unchecked")
	/**
	 * Returns EObject[] of selected (checked) model entities for given annotation type);
	 */
	public EObject[] getSelectedEntitiesForAnnoataionType(EClass annType){
		int index = -1;
		for (int i=0; i < annotationTypes.length; i ++){
			if (annType == this.annotationTypes[i]){
				index = i;
			}
		}
		if (index == -1){
			logger.error("Trying to get selected objectts for non existing annnotation Type");
			return new EObject[0];
		} else {
			return (EObject[]) ((ArrayList<EObject>)entityViewer.selectedEntities[index]).
					 toArray(
					 new EObject[((ArrayList<EObject>)entityViewer.selectedEntities[index]).size()]
					);
		}
	}
	
	public void handleAnnotationSelection(int index) {
		this.entityViewer.selectedAnotationChanged( annotationTypes[index], 
					((SelectProjectPage) this.getPreviousPage()).getSelectedProject(), index);
	}
	
	private List createAnnotationTypeList(Composite parent) {
		final List annotationTypeList = new List(parent, SWT.BORDER | SWT.SINGLE);
		GridDataFactory.fillDefaults().span(1, 2).grab(true,true).applyTo(annotationTypeList);
		
		annotationTypeList.addSelectionListener(new SelectionAdapter() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				int index = 0;
				if ((index = annotationTypeList.getSelectionIndex()) != -1) {					
					handleAnnotationSelection(index);
				}
			}			
		} ) ;
		
		return annotationTypeList;
	}
		
	
	@SuppressWarnings("unchecked")
	public boolean validatePage() {
		boolean valid = false;
		this.entityViewer.saveCurrentSelection();
		for (int i = 0; i < annotationTypes.length; i++){
			if (0 < ((ArrayList<EObject>) (this.entityViewer.selectedEntities[i])).size()  ){
				valid = true;
				break;
			}
		}
		setPageComplete(valid);
		return valid;
	}
}
