package eu.qimpress.ide.editors.form.qoseditor.wizards.pages;

import java.util.Map;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import eu.qimpress.ide.backbone.core.ui.models.ShadowModelEditorUtils;
import eu.qimpress.ide.editors.form.qoseditor.QoSEditorUtils;
import eu.qimpress.ide.editors.form.qoseditor.properties.EMFExtendedPropertySheetPage;
import eu.qimpress.ide.editors.form.qoseditor.wizards.QoSAnnotationWizard;
import eu.qimpress.samm.qosannotation.Annotation;

public class AnnotationInstanceEditorPage extends WizardPage{
	
	public int pageId;
	
	public EClass annotationType;
	
	public eu.qimpress.samm.qosannotation.Annotation annotationInstance;
	
	public EObject entityToAnnotate;
	
	/** Annotation editor */
	private EMFExtendedPropertySheetPage annotationEntityPrototypeEditor = null;
	
	/** Selected SAMM property viewer */
	private EMFExtendedPropertySheetPage annotatedObjectPropertyDisplayer = null;
	
	/** Map of annotation prototypes */ 
	private Map<EClass, Annotation> annotationPrototypes;
	
	
	public void setPageId(int pageId){
		this.pageId = pageId;
	}
	
	public AnnotationInstanceEditorPage() {
		super("Annotation Wizard - Annotation Editor.");
		setPageComplete(true);
	
		setTitle("Annotation Wizard - Annotation Editor");
		setDescription("Final Annotation editor");	
		
		
	}
	
	public void setAnnotationTypeAndObject(EClass annotationType, EObject entityToAnnotate){
		this.entityToAnnotate = entityToAnnotate;
		this.annotationType = annotationType;
		
		EClass[] annotationTypes = QoSEditorUtils.getDefinedAnnotationsTypes();
		annotationPrototypes = QoSEditorUtils.createPrototypeInstances(annotationTypes);
		
		this.annotationInstance = annotationPrototypes.get(this.annotationType);

	}
	
	@Override
	public void createControl(Composite parent) {
		final Composite composite = new Composite(parent, SWT.NULL);
		
		initializeDialogUnits(parent);
		composite.setLayout(new GridLayout(1, true));
		
		setControl(composite);
		
		Label annotationSelectorLabel = new Label(composite, SWT.NONE);
		annotationSelectorLabel.setText("Annotation Instance editor (couple " + pageId + ", annotation type = " + annotationType.getName() + ", entity = " + entityToAnnotate.getClass().getName() + ")");
		GridDataFactory.generate(annotationSelectorLabel, 1, 1);
		
		
		
		
		annotationEntityPrototypeEditor = new EMFExtendedPropertySheetPage();
		annotationEntityPrototypeEditor.createControl(composite);
		GridDataFactory.generate(annotationEntityPrototypeEditor.getControl(), 1, 1);
		
		
		
		
		annotatedObjectPropertyDisplayer = new EMFExtendedPropertySheetPage();
		annotatedObjectPropertyDisplayer.createControl(composite);
		GridDataFactory.generate(annotatedObjectPropertyDisplayer.getControl(), 1, 1);
		
		
		
		this.annotationInstance = annotationPrototypes.get(this.annotationType);
		
		try {
			annotationEntityPrototypeEditor.selectionChanged(null, new StructuredSelection(this.annotationInstance));
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		
				
		try {
			annotationEntityPrototypeEditor.setEditingDomain((AdapterFactoryEditingDomain) ShadowModelEditorUtils.getDefaultEditingDomain((((QoSAnnotationWizard)getWizard()).selectProjectPage.getSelectedProject()).getProject() ));
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		
		annotatedObjectPropertyDisplayer.selectionChanged(null, new StructuredSelection(entityToAnnotate));
	}
}
