/**
 * 
 */
package eu.qimpress.ide.editors.form.qoseditor.wizards;

import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;
import eu.qimpress.ide.backbone.core.operations.SaveQModelUIOperation;
import eu.qimpress.ide.editors.form.qoseditor.QoSEditorUtils;
import eu.qimpress.ide.editors.form.qoseditor.properties.AssociatedQoSAnnotationSection;
import eu.qimpress.ide.editors.form.qoseditor.wizards.pages.AnnotationInstanceEditorPage;
import eu.qimpress.ide.editors.form.qoseditor.wizards.pages.SelectAnnotationAndEntitiesPage;
import eu.qimpress.ide.editors.form.qoseditor.wizards.pages.SelectProjectPage;

/**
 * Annotation wizard allows developers to annotate given elements with the selected annotations.
 * 
 * @author Tomas Pop
 *
 */

final class AnnotationCouple {
	public EClass annotationType;
	public EObject entity;
	
	public AnnotationCouple(EClass annotationType, EObject entity){
		this.annotationType = annotationType;
		this.entity = entity;
	}
	
}


public class QoSAnnotationWizard extends Wizard implements INewWizard {
	
	/** project could be selected */
	private IStructuredSelection initialSelection;
	
	/** select project page */
	public SelectProjectPage selectProjectPage;
	
	/** select annotations page */
	private SelectAnnotationAndEntitiesPage selectAnnotationAndEntitiesPage;
	
	/** Project selected before wizard was run */
	private IQProject initialSelectedProject;
	
	public static final Logger logger = Logger.getLogger(AssociatedQoSAnnotationSection.class);
	
	/** Wizard ID */
	public static final String WIZARD_ID = "eu.qimpress.ide.editors.form.qoseditor.QoSAnnotationWizardID";
	
	/** To be annotated couples */ 
	private ArrayList<AnnotationCouple> annotationCouples = new ArrayList<AnnotationCouple>();
	
	private int coupleIndex = 0;
	
	public EClass[] annotationTypes;

	
	public QoSAnnotationWizard() {		
		annotationTypes = QoSEditorUtils.getDefinedAnnotationsTypes();
	}
	
	public boolean performFinishOld() {
		EObject[] entitiesToAnnotate;
		eu.qimpress.samm.qosannotation.Annotation annotation;
		IQProject project = selectProjectPage.getSelectedProject();
		
		for (EClass annType : annotationTypes){
			entitiesToAnnotate = selectAnnotationAndEntitiesPage.getSelectedEntitiesForAnnoataionType(annType);
			for (EObject entityToAnnotate: entitiesToAnnotate){
				try {
					annotation = QoSEditorUtils.addNewAnnotation(project.getProject(), annType);
					QoSEditorUtils.setAnnotationReference(annotation, entityToAnnotate);
				} catch (RepositoryException e) {
					logger.error("Annotation Wizard: Repository Exception, " + e.getMessage());
				}
			}
		}
		
		try {
			IQModel annotationModel = project.	getRepository().getDefaultAlternative().
												getModel(RepositoryModels.ANNOTATION_MODEL_EXT);
			getContainer().run(false, false, new SaveQModelUIOperation(annotationModel));
		} catch (Exception e) {
			logger.error("Annotation Wizard: Can not get container, " + e.getMessage());
			return false;
		}
		
		return true;
	}
	
	@Override
	public boolean performFinish() {		
		IQProject project = selectProjectPage.getSelectedProject();
		IWizardPage[] pages = this.getPages();
		
		
		for (IWizardPage pg : pages){
			if (null != pg && pg instanceof AnnotationInstanceEditorPage){
				System.out.println("ANNOTATION WIZARD.FINISH: Annotating [ID = " + ((AnnotationInstanceEditorPage) pg ).pageId + "] " + ((AnnotationInstanceEditorPage) pg ).entityToAnnotate  + " by " + ((AnnotationInstanceEditorPage) pg ).annotationInstance.getName());
				try {
					QoSEditorUtils.addNewAnnotationInstance(project.getProject(), ((AnnotationInstanceEditorPage) pg).annotationInstance);
					QoSEditorUtils.setAnnotationReference( ((AnnotationInstanceEditorPage) pg ).annotationInstance, ((AnnotationInstanceEditorPage) pg ).entityToAnnotate  );
				} catch (RepositoryException e) {
					e.printStackTrace();
					logger.error("Annotation Wizard: Repository Exception, " + e.getMessage());
				}	
			}
		}
			
		try {
			IQModel annotationModel = project.	getRepository().getDefaultAlternative().
												getModel(RepositoryModels.ANNOTATION_MODEL_EXT);
			getContainer().run(false, false, new SaveQModelUIOperation(annotationModel));
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Annotation Wizard: Can not get container, " + e.getMessage());
			return false;
		}
		
		
		return true;
	}


	
	@Override
	public void addPages() {
		initialSelectedProject = null;
		
		if (initialSelection.size() == 1) {
			Object o = initialSelection.getFirstElement();
			IProject project = null;
			if (o instanceof IResource) {
				project = ((IResource) o).getProject();
			} else if (o instanceof IAdaptable) {
				IResource res = (IResource) ((IAdaptable) o).getAdapter(IResource.class);
				if (res != null) {
					project = res.getProject();
				}
			}
					
			/** initial project already selected */
			initialSelectedProject = QImpressCore.getQProject(project);
		}
		
		/* START quick fix, remove me, but then if project is selected in project explorer things go wrong.. */
		initialSelectedProject = null;
		/* END of quick fix */
		
		selectProjectPage = new SelectProjectPage(initialSelectedProject);
		addPage(selectProjectPage);
		
		
		
		selectAnnotationAndEntitiesPage = new SelectAnnotationAndEntitiesPage(initialSelectedProject);
		addPage(selectAnnotationAndEntitiesPage);
		
		
		
		
		// resize the wizard
		Point size = getContainer().getShell().getSize();
		getContainer().getShell().setSize(size.x + size.x/3, size.y + size.y/4);
	}
	
	
	private void generateCouples(){
		EClass[] annotationTypes = QoSEditorUtils.getDefinedAnnotationsTypes();
		EObject[] entitiesToAnnotate;
		
		this.annotationCouples = new ArrayList<AnnotationCouple>();
		
		for (EClass annType : annotationTypes){
			entitiesToAnnotate = selectAnnotationAndEntitiesPage.getSelectedEntitiesForAnnoataionType(annType);
			for (EObject entityToAnnotate: entitiesToAnnotate){
				this.annotationCouples.add(new AnnotationCouple(annType, entityToAnnotate));
			}
		}
	}
	
	
	@Override
	public IWizardPage getNextPage(IWizardPage page){
		
		if (page instanceof SelectAnnotationAndEntitiesPage){
			generateCouples();
			while (coupleIndex < annotationCouples.size()){
				AnnotationInstanceEditorPage newPage = new AnnotationInstanceEditorPage();
				newPage.setAnnotationTypeAndObject(annotationCouples.get(coupleIndex).annotationType, annotationCouples.get(coupleIndex).entity);
				newPage.setPageId(coupleIndex);
				coupleIndex ++ ;
				this.addPage(newPage);
			}
		}
		return super.getNextPage(page);
	}

		
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.initialSelection = selection;
	}
	
	
}