/**
 * 
 */
package eu.qimpress.ide.editors.form.qoseditor.properties;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.viewers.IFilter;

import eu.qimpress.ide.editors.form.qoseditor.QoSEditorUtils;
import eu.qimpress.ide.editors.form.qoseditor.internal.QoSAnnotationCache;
import eu.qimpress.samm.qosannotation.QosAnnotations;

/**
 * @author Michal Malohlava
 *
 */
public class QoSTypeFilter implements IFilter {
	
	private static final Logger logger = Logger.getLogger(QoSTypeFilter.class);
		
	public QoSTypeFilter() {		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IFilter#select(java.lang.Object)
	 */
	public boolean select(Object toTest) {
		Class clazz = toTest.getClass();
		
		// enable just for Q-I NamedEntity elements, omit QoSAnnotations repository
		if (!(toTest instanceof QosAnnotations)) {
			EClass[] definedAnnotationTypes = QoSAnnotationCache.getInstance().getDefinedAnnotationTypes(); 			
			
			for (EClass eclazz : definedAnnotationTypes) {
				if (QoSEditorUtils.containsAttributeForType(eclazz, clazz)) {
					logger.debug("Object " + toTest + " is supported by annotation type " + eclazz);
					return true;			
				}
			}
		}
		
		return false;
	}

}
