/**
 * 
 */
package eu.qimpress.ide.editors.form.qoseditor.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

import eu.qimpress.ide.backbone.core.ui.models.ShadowModelEditor;
import eu.qimpress.ide.backbone.core.ui.models.ShadowModelEditorUtils;

/**
 * 
 * @author Michal Malohlava
 *
 */
public class EMFExtendedPropertySheetPage extends ExtendedPropertySheetPage {

	public EMFExtendedPropertySheetPage() {
		this(null);
	}
	
	public EMFExtendedPropertySheetPage(
			AdapterFactoryEditingDomain editingDomain) {
		super(editingDomain);		
	}
	
	public void setEditingDomain(AdapterFactoryEditingDomain editingDomain) {
		this.editingDomain = editingDomain;
	}
	
	public AdapterFactoryEditingDomain getEditingDomain() {
		return this.editingDomain;
	}
	
	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {		
		super.selectionChanged(part, selection);
		
		EObject eo = getEObjectFromSelection(selection);
		
		if (eo != null) {
			ShadowModelEditor shmEditor = ShadowModelEditorUtils.getShadowModelEditor(eo);
			if (shmEditor != null) {			
				setEditingDomain((AdapterFactoryEditingDomain) shmEditor.getEditingDomain());
			}
		}		
	}
	
	
	public void setEditedEobject(EObject eobject) {		
		super.selectionChanged(null, new StructuredSelection(eobject));
		if (eobject != null) {
			ShadowModelEditor shmEditor = ShadowModelEditorUtils.getShadowModelEditor(eobject);
			if (shmEditor != null) {			
				setEditingDomain((AdapterFactoryEditingDomain) shmEditor.getEditingDomain());
			}
		}		
	}	
	
	private EObject getEObjectFromSelection(ISelection selection) {
		if (selection instanceof IStructuredSelection
				&& !((IStructuredSelection) selection).isEmpty()) {
			Object o = ((IStructuredSelection) selection).getFirstElement();
			
			if (o instanceof EObject) {
				return (EObject) o;
			}
		}
		
		return null;
	}
	
	
	
	
}
