/**
 * 
 */
package eu.qimpress.ide.editors.form.qoseditor.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

import eu.qimpress.samm.qosannotation.QosannotationPackage;

/**
 * Cached information about QoS annotations
 * 
 * @author Michal Malohlava
 *
 */
public class QoSAnnotationCache {
	
	private static final EStructuralFeature[] EMPTY_FEATURE_LIST = new EStructuralFeature[] {};
	
	/** singleton */
	private static QoSAnnotationCache INSTANCE;
	
	/** list of annotations */
	private List<EClass> annotationList = new ArrayList<EClass>();

	/** map of annotation X interesting features */
	private Map<EClass, List<EStructuralFeature>> annotationFeaturesMap = new HashMap<EClass, List<EStructuralFeature>>();
	
	private List<EStructuralFeature> annotationsFeaturesList = new ArrayList<EStructuralFeature>();
	
	private EStructuralFeature[] ignoredFeatures;
	
	public static QoSAnnotationCache getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new QoSAnnotationCache();
		}
		
		return INSTANCE;
	}
	
	private QoSAnnotationCache() {
		initialize();
	}
	
	public void initialize() {
		initIgnoredFeatures();
		
		initAnnotationList();
	}
	
	private void initIgnoredFeatures() {
		ignoredFeatures = QosannotationPackage.eINSTANCE.getAnnotation().getEAllStructuralFeatures().toArray(new EStructuralFeature[] {});
	}
	
	private void initAnnotationList() {
		annotationList.clear();
		
		IConfigurationElement[] annotations = Platform.getExtensionRegistry().getConfigurationElementsFor("eu.qimpress.samm.qosannotations");
				
		for (int i=0; i<annotations.length; i++) {
			EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(annotations[i].getAttribute("uri"));
			EClassifier classifier = ePackage.getEClassifier(annotations[i].getAttribute("class"));
			
			if (classifier == null) {
				continue;
			}
			
			if ((eu.qimpress.samm.qosannotation.Annotation.class.isAssignableFrom(classifier.getInstanceClass())) && (!classifier.getInstanceClass().equals(eu.qimpress.samm.qosannotation.Annotation.class))) {
				EClass annotationType = (EClass) classifier;
				
				annotationList.add(annotationType);
				
				List<EStructuralFeature> structuralFeatures = collectStructuralFeatures(annotationType);
				annotationFeaturesMap.put(annotationType, structuralFeatures);
				
				annotationsFeaturesList.addAll(structuralFeatures);
			}
		}
	}

	private List<EStructuralFeature> collectStructuralFeatures(EClass annotationType) {
		List<EStructuralFeature> result = new ArrayList<EStructuralFeature>(4);
		
		for(EStructuralFeature esf : annotationType.getEAllStructuralFeatures()) {
			if (esf.isChangeable() 
					&& !esf.isMany()
					&& !isIgnoredFeature(esf)) {
				result.add(esf);				
			}			
		}
		
		return result;
	}
	
	private boolean isIgnoredFeature(EStructuralFeature esf) {
		for (EStructuralFeature iEsf : ignoredFeatures) {
			if (iEsf.equals(esf)) {
				return true;
			}
		}
		
		return false;
	}
	
	/* Public interface */	
	public EClass[] getDefinedAnnotationTypes() {
		return annotationList.toArray(new EClass[annotationList.size()]);
	}
	
	public EStructuralFeature[] getAllAnnotationsFeatures() {
		return annotationsFeaturesList.toArray(new EStructuralFeature[annotationsFeaturesList.size()]); 
	}
	
	public EStructuralFeature[] getAnnotationFeatures(EClass eClazz) {
		if (annotationFeaturesMap.containsKey(eClazz)) {
			List<EStructuralFeature> features = annotationFeaturesMap.get(eClazz);
			
			return features.toArray(new EStructuralFeature[features.size()]); 			
		} else {
			return EMPTY_FEATURE_LIST; 
		}
	}
}
