package eu.qimpress.ide.editors.dialogs.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import eu.qimpress.ide.ui.dialogs.selection.ExcludingFilteredItemsAdapterFactory;
import eu.qimpress.ide.ui.dialogs.selection.SelectEObjectDialog;
import eu.qimpress.samm.behaviour.provider.BehaviourItemProviderAdapterFactory;
import eu.qimpress.samm.deployment.allocation.provider.AllocationItemProviderAdapterFactory;
import eu.qimpress.samm.deployment.hardware.provider.HardwareItemProviderAdapterFactory;
import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.deployment.targetenvironment.provider.TargetenvironmentItemProviderAdapterFactory;
import eu.qimpress.samm.staticstructure.provider.StaticstructureItemProviderAdapterFactory;

/**
 * @author wsa
 *
 */
public class SammEObjectSelectionDialog extends SelectEObjectDialog {

	private Object input;
	private AdapterFactoryContentProvider contentProvider;

	public SammEObjectSelectionDialog(Shell parent,
			Collection<Object> filterList,
			Collection<EReference> additionalChildReferences, 
			Set<EReference> excludedContainments,
			Object input) {
		super(parent);
		this.input = input;
		create();
		ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
		adapterFactory.addAdapterFactory(new ResourceItemProviderAdapterFactory());
		adapterFactory.addAdapterFactory(new StaticstructureItemProviderAdapterFactory());
		adapterFactory.addAdapterFactory(new BehaviourItemProviderAdapterFactory());
		adapterFactory.addAdapterFactory(new AllocationItemProviderAdapterFactory());
		adapterFactory.addAdapterFactory(new TargetenvironmentItemProviderAdapterFactory());
		adapterFactory.addAdapterFactory(new HardwareItemProviderAdapterFactory());
		
		contentProvider = new AdapterFactoryContentProvider(
				new ExcludingFilteredItemsAdapterFactory(adapterFactory, filterList,
						additionalChildReferences, excludedContainments));
		setViewerContentProvider(contentProvider);
		
		setViewerLabelProvider(new AdapterFactoryLabelProvider(adapterFactory));
		setViewerInput(input);
		setInputDialogResourceName(filterList);
	}
	
	public SammEObjectSelectionDialog(Shell parent,
			Collection<Object> filterList, Object input) {
		this(parent, filterList, new ArrayList<EReference>(), new HashSet<EReference>(), input);
	}
	
	/* (non-Javadoc)
	 * @see de.uka.ipd.sdq.dialogs.selection.SelectEObjectDialog#addModelToResourceSet(org.eclipse.swt.widgets.Shell, java.lang.String)
	 */
	@Override
	protected void addModelToResourceSet(Shell shell, String uri) {
		ResourceSet resourceSet = getResourceSet(input);
		
		if (resourceSet != null) {
			URI model = URI.createURI(uri);
			try {
				resourceSet.getResource(model, true);
			} catch (Throwable t) {
				MessageDialog.openInformation(shell, "Resource Loader Error", t
						.getMessage());
			}
		}
	}

	/* (non-Javadoc)
	 * @see de.uka.ipd.sdq.dialogs.selection.SelectEObjectDialog#setInputDialogResourceName(java.util.Collection)
	 */
	@Override
	protected void setInputDialogResourceName(Collection<Object> filterList) {
		String system = "System";
		String repository = "Repository";
		String resourceRepository = "ResourceRepository";

		ArrayList<Object> list = new ArrayList<Object>();
		list.addAll(filterList);

		if (!list.isEmpty()) {
			for (Object object : list) {
				Class<?> clazz = (Class<?>) object;
				String name = clazz.getSimpleName();
				if (name.equals(system) || name.equals(repository)
						|| name.equals(resourceRepository))
					setResourceName(name);
			}
		}
	}

	/**
	 * Get a resource set from dialog input object
	 * 
	 * @param object -
	 *            dialog input object
	 */
	protected ResourceSet getResourceSet(Object object) {
		/** ResourceSet */
		if (object instanceof ResourceSet)
			return (ResourceSet) object;
		/** EObject */
		if (object instanceof EObject) {
			TransactionalEditingDomain editingDomain = TransactionUtil
					.getEditingDomain((EObject) object);
			if (editingDomain != null)
				return editingDomain.getResourceSet();
		}
		return null;
	}
	

}
