package org.ow2.dsrg.fm.tbpjava.utils;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

import org.ow2.dsrg.fm.tbpjava.envgen.EnvValueSets;

public class Type2String {
	private static final boolean DEBUG = false;
	/// Mark is in final generated code will be generic types used.
	public static final boolean USE_GENERIC_TYPE = true; 

	/**
	 * Gets usable string representation for source code type casting. USed for generic definition
	 *
	 * @param types Types you want to convert to string.
	 * @return String usable in source code for overcasting
	 */
	public static String getGenericsTypeNames(Type[] types) {
		if (types == null || types.length == 0) {
			return "";
		}
		
		StringBuffer result = new StringBuffer();
		result.append('<');
		boolean first = true;
		for(Type type : types) {
			if (first) {
				first = false;
			} else {
				result.append(", ");
			}
			result.append( getTypeName(type));
		}
		result.append('>');
		return result.toString();
	}

	/**
	 * Gets usable string representation for source code type casting.
	 * @param type Type you want to convert to string.
	 * @return String usable in source code for overcasting
	 * 
	 * Note: Have some bugs. (I hope not :-)
	 */
	public static String getTypeName(Type type) {
		if (DEBUG) { System.out.println(EnvValueSets.class.getSimpleName() + ":getTypeName(type=" + type + ")"); }
		if (type == null) {
			return "";
		}
		// The only four implementing interfaces GenericArrayType, ParameterizedType, TypeVariable<D>, WildcardType
		// And class of course if not a generic type.
		if (type instanceof GenericArrayType) {
			if (DEBUG) { System.out.println(EnvValueSets.class.getSimpleName() + ":getTypeName - GenericArrayType"); }
			// Type represents something like ArrayList<String>[]
			GenericArrayType gatType =(GenericArrayType) type;
			return getTypeName(gatType.getGenericComponentType()) + "[]";
		} else
		if (type instanceof ParameterizedType) {
			if (DEBUG) { System.out.println(EnvValueSets.class.getSimpleName() + ":getTypeName - ParameterizedType"); }
			// Type represents something like ArrayList<String>
			ParameterizedType ptType = (ParameterizedType)type;
			StringBuffer result = new StringBuffer(getTypeName(ptType.getRawType()));
			if (USE_GENERIC_TYPE) {
				result.append('<');
				boolean first = true;
				for(Type typeArgument : ptType.getActualTypeArguments()) {
					if (first) {
						first = false;
					} else {
						result.append(", ");
					}
					result.append( getTypeName(typeArgument));
				}
				result.append('>');
			}
			return result.toString();
			
		} else 
		if (type instanceof TypeVariable<?>) {
			if (DEBUG) { System.out.println(EnvValueSets.class.getSimpleName() + ":getTypeName - TypeVariable"); }
			if (!USE_GENERIC_TYPE) {
				return "";
			}
			TypeVariable<?> tvType = (TypeVariable<?>)type;
			return tvType.getName();
		} else
		if (type instanceof WildcardType) {
			if (DEBUG) { System.out.println(EnvValueSets.class.getSimpleName() + ":getTypeName - WildcardType"); }
			if (!USE_GENERIC_TYPE) {
				return "";
			}
			WildcardType wtType = (WildcardType)type;
			StringBuffer result = new StringBuffer();
			
			// Check for bounds
			Type[] lb = wtType.getLowerBounds(); // Lower bound
			Type[] ub = wtType.getUpperBounds(); // Upper bound
			result.append("?");

			if (lb != null && lb.length > 0) {
				if (lb.length > 1) {
					throw new RuntimeException("Internal error - not supported by Java language - more lower bounds (super) in one declaration");
				}
				result.append(" super ");
				result.append( getTypeName(lb[0]));
			} else // Else has to be here (lb and ub cannot't be set in one expression) 
			if (ub != null && ub.length > 0) {
				if (ub.length > 1) {
					throw new RuntimeException("Internal error - not supported by Java language - more upper bounds (extends) in one declaration");
				}
//				if (!(ub[0].equals(Object.class))) {
				// Object class is returned by default event if not specified (or in case of that lower bound is set)
					result.append(" extends ");
					result.append( getTypeName(ub[0]));
//				}
			}
			
			return result.toString();
		} else
			if (type instanceof Class<?>) {
			Class<?> cls = (Class<?>)type;
			// There are some cases we has to solve
			//  a) primitive types
			//  b) arrays ... recursion
			if (cls.equals(boolean.class)) {
				return boolean.class.getName();
			} else if (cls.equals(byte.class)) {
				return byte.class.getName();
			} else if (cls.equals(short.class)) {
				return short.class.getName();
			} else if (cls.equals(int.class)) {
				return int.class.getName();
			} else if (cls.equals(long.class)) {
				return long.class.getName();
			} else if (cls.equals(char.class)) {
				return char.class.getName();
			} else if (cls.equals(float.class)) {
				return float.class.getName();
			} else if (cls.equals(double.class)) {
				return double.class.getName();
			}

			if (cls.isArray()) {
				return getTypeName(cls.getComponentType()) + "[]";
			}
			
			// Type is class of interface ... can be generic
			return cls.getName();
		}
		
		throw new RuntimeException("Given type parameter is not instance of Class and doesn't implement any of these interfaces . This should not occur GenericArrayType, ParameterizedType, TypeVariable<D>, WildcardType. Type is instance of " + type.getClass().getName());
		
	}

	/**
	 * Gets usable string representation for source code declaration of generic type variable.
	 * @param type Type you want to convert to string.
	 * @return String usable in generated source code. 
	 * 
	 * Note: Generic type definition takes place e.g 
	 *      class MyClass<HERE> {
	 *          [static] <HERE> void MyMethod();
	 * Note: Generic type definition can be e.g 
	 *    <T, L> or <T extends EnvValueSet> <T extends EnvValueSet & Set<T>>
	 * but not <? extends L>, <T super EnvValueSet>
	 * 
	 * Note: Generic type definition can be obtained by {@link GenericDeclaration#getTypeParameters()} call.
	 */
	public static String getGenericTypeDefinition(Type[] types) {
		if (DEBUG) { System.out.println(EnvValueSets.class.getSimpleName() + ":getGenericTypeDefinition(types=" + types + ")"); }
		if (types == null || types.length == 0) {
			return "";
		}
		if (!USE_GENERIC_TYPE) {
			return ""; // Doesn't give sense use this method if generics not used
		}
		StringBuffer result = new StringBuffer();
		result.append('<');
		boolean first = true;
		for(Type type : types) {
			if (first) {
				first = false;
			} else {
				result.append(", ");
			}
			result.append(getGenericTypeDefinitionOneEntry(type));
		}
		result.append('>');
		return result.toString();
	}

	/**
	 * Processes one entry from generic type definition.
	 * @param type Type you want to convert to string.
	 * @return String usable in generated source code. 
	 */
	public static String getGenericTypeDefinitionOneEntry(Type type) {
		if (DEBUG) { System.out.println(EnvValueSets.class.getSimpleName() + ":getGenericTypeDefinitionOneEntry(type=" + type + ")"); }
		if (type == null) {
			return "";
		}
		if (!USE_GENERIC_TYPE) {
			return ""; // Doesn't give sense use this method if generics not used
		}

		// The only one implementing interfaces TypeVariable<D> is expected
		//  others cannot be in the top level structure
		if (type instanceof TypeVariable<?>) {
			if (DEBUG) { System.out.println(EnvValueSets.class.getSimpleName() + ":getGenericTypeDefinitionOneEntry - TypeVariable"); }

			TypeVariable<?> tvType = (TypeVariable<?>)type;
			StringBuffer result = new StringBuffer();
			result.append(tvType.getName());
			Type[] bounds = tvType.getBounds();
			// Only if any bound exists, and if exists only one that it's not Object (default values!!)
			if (bounds != null && ((bounds.length > 1) || (bounds.length == 1 && !bounds[0].equals(Object.class)))) {
				boolean first = true;
				for(Type bound : bounds) {
					if (first) {
						first = false;
						result.append(" extends ");
					} else {
						result.append(" & ");
					}
					result.append(getTypeName(bound));
				}
			}
			return result.toString();
		}
		
		throw new RuntimeException("The provided type parameter is not an instance of Class and doesn't implement any of these interfaces. This should not occur GenericArrayType, ParameterizedType, TypeVariable<D>, WildcardType. Type is instance of " + type.getClass().getName());
		
	}
	
	/**
	 * From given string with type name removes generic part. If string doesn't contain generic part that is returned unmodified
	 * @param typeName String to process
	 * @return Name of the class without generics part.
	 */
	public static String removeGenerics(String typeName) {
		if (typeName == null) {
			return "";
		}
		
		int startGenDec = typeName.indexOf('<');
		int endGenDec   = typeName.lastIndexOf('>');
		if (startGenDec == -1 || endGenDec == -1 ||
		        endGenDec <= startGenDec) {
			// not contains generic part or malformed name
			return typeName;
		}
			
		String result = typeName.substring(0, startGenDec);
		if (endGenDec < typeName.length()) {
			result += typeName.substring(endGenDec+1);
		}
		return result;
	}
	
	/**
	 * Gets generic part (with <>) from given type name. If no such part gets empty string.
	 * @param typeName Name of the type to process
	 * @return Generic part of type name.
	 */
	public static String getGenerics(String typeName) {
		if (typeName == null) {
			return "";
		}
		
		int startGenDec = typeName.indexOf('<');
		int endGenDec   = typeName.lastIndexOf('>');
		if (startGenDec == -1 || endGenDec == -1 ||
		        endGenDec <= startGenDec) {
			// not contains generic part or malformed name
			return "";
		}
		return typeName.substring(startGenDec, endGenDec+1);
	}

}
